/*
 * Decompiled with CFR 0.152.
 */
package cn.svipbot.gocq.handler;

import cn.svipbot.gocq.bot.Bot;
import cn.svipbot.gocq.bot.BotContainer;
import cn.svipbot.gocq.bot.BotFactory;
import cn.svipbot.gocq.handler.ApiHandler;
import cn.svipbot.gocq.handler.EventHandler;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class BotWebSocketHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(BotWebSocketHandler.class);
    private final Object $lock = new Object[0];
    @Autowired
    BotFactory botFactory;
    @Autowired
    ApiHandler apiHandler;
    @Autowired
    EventHandler eventHandler;
    @Autowired
    BotContainer botContainer;
    @Autowired
    ExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionEstablished(WebSocketSession session) throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            Optional.ofNullable(session.getHandshakeHeaders().getFirst("x-self-id")).map(Long::valueOf).ifPresent(xSelfId -> {
                log.info("qq\uff1a{} websocket\u901a\u8baf\u8fde\u63a5\u6210\u529f", xSelfId);
                this.botContainer.getBots().put((Long)xSelfId, this.botFactory.createBot((Long)xSelfId, session));
                log.info("bot\uff1a{} \u5df2\u7ecf\u6dfb\u52a0\u5230\u7ba1\u7406\u5668\u4e2d", xSelfId);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            Optional.ofNullable(session.getHandshakeHeaders().getFirst("x-self-id")).map(Long::valueOf).ifPresent(xSelfId -> {
                log.info("QQ\uff1a{} websocket\u901a\u8baf\u65ad\u5f00\u8fde\u63a5", xSelfId);
                this.botContainer.getBots().remove(xSelfId);
                log.info("bot\uff1a{} \u5df2\u7ecf\u4ece\u7ba1\u7406\u5668\u4e2d\u79fb\u9664", xSelfId);
            });
        }
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        Long xSelfId = Long.parseLong(session.getHandshakeHeaders().getFirst("x-self-id"));
        Optional.ofNullable(xSelfId).ifPresent(uin -> {
            Bot bot = this.botContainer.getBots().computeIfAbsent((Long)uin, k -> this.botFactory.createBot((Long)k, session));
            bot.setBotSession(session);
            JSONObject payloadJson = JSON.parseObject((String)((String)message.getPayload()));
            if (payloadJson.containsKey("echo")) {
                this.apiHandler.onReceiveApiMessage(payloadJson);
            } else {
                this.executor.execute(() -> this.eventHandler.handle(bot, payloadJson));
            }
        });
    }
}

