/*
 * Decompiled with CFR 0.152.
 */
package cn.svipbot.gocq.handler;

import cn.svipbot.gocq.bot.IApiRequest;
import cn.svipbot.gocq.config.BotProperties;
import cn.svipbot.gocq.enums.Api;
import cn.svipbot.gocq.handler.ApiSender;
import com.alibaba.fastjson2.JSONObject;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class ApiHandler {
    private static final Logger log = LoggerFactory.getLogger(ApiHandler.class);
    @Autowired
    BotProperties botProperties;
    private final AtomicLong apiEcho = new AtomicLong();
    private final Map<String, ApiSender> apiCallbackMap = new ConcurrentHashMap<String, ApiSender>();

    public void onReceiveApiMessage(JSONObject message) {
        String echo = message.getString("echo");
        ApiSender apiSender = this.apiCallbackMap.get(echo);
        if (apiSender != null) {
            apiSender.onReceiveJson(message);
            this.apiCallbackMap.remove(echo);
        }
    }

    private JSONObject constructApiJson(IApiRequest apiRequest) {
        JSONObject apiJson = new JSONObject();
        apiJson.put((Object)"action", (Object)apiRequest.getAction());
        JSONObject params = apiRequest.getParams();
        if (params != null) {
            apiJson.put((Object)"params", (Object)params);
        }
        apiJson.put((Object)"echo", (Object)this.apiEcho.getAndIncrement());
        return apiJson;
    }

    private JSONObject constructApiJson(Api api, JSONObject params) {
        JSONObject apiJson = new JSONObject();
        apiJson.put((Object)"action", (Object)api.getAction());
        if (params != null) {
            apiJson.put((Object)"params", (Object)params);
        }
        apiJson.put((Object)"echo", (Object)this.apiEcho.getAndIncrement());
        return apiJson;
    }

    public JSONObject sendApiMessage(WebSocketSession botSession, IApiRequest apiRequest) throws IOException, InterruptedException {
        JSONObject apiJson = this.constructApiJson(apiRequest);
        String echo = apiJson.getString("echo");
        ApiSender apiSender = new ApiSender(botSession, this.botProperties.getApiTimeout());
        this.apiCallbackMap.put(echo, apiSender);
        return apiSender.sendApiJson(apiJson);
    }

    public JSONObject sendApiMessage(WebSocketSession botSession, Api api, JSONObject params) {
        JSONObject apiJson = this.constructApiJson(api, params);
        String echo = apiJson.getString("echo");
        ApiSender apiSender = new ApiSender(botSession, this.botProperties.getApiTimeout());
        this.apiCallbackMap.put(echo, apiSender);
        try {
            return apiSender.sendApiJson(apiJson);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25: [{}]", (Object)api.getDescription(), (Object)e);
            JSONObject retJson = new JSONObject();
            retJson.put((Object)"status", (Object)"failed");
            retJson.put((Object)"retcode", (Object)-1);
            return retJson;
        }
    }
}

