/*
 * Decompiled with CFR 0.152.
 */
package cn.svipbot.gocq.config;

import cn.svipbot.gocq.config.BotProperties;
import cn.svipbot.gocq.config.EventProperties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;

@Component
public class BotBean {
    @Autowired
    private BotProperties botProperties;
    @Autowired
    private EventProperties eventProperties;

    @Bean
    @ConditionalOnMissingBean
    public ExecutorService createExecutor() {
        return new ThreadPoolExecutor(this.eventProperties.getCorePoolSize(), this.eventProperties.getMaxPoolSize(), this.eventProperties.getKeepAliveTime(), TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.eventProperties.getWorkQueueSize()));
    }

    @Bean
    @ConditionalOnMissingBean
    public ServletServerContainerFactoryBean createWebSocketContainer() {
        ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
        container.setMaxSessionIdleTimeout(Long.valueOf(this.botProperties.getMaxSessionIdleTimeout()));
        container.setMaxTextMessageBufferSize(Integer.valueOf(this.botProperties.getMaxTextMessageBufferSize()));
        container.setMaxBinaryMessageBufferSize(Integer.valueOf(this.botProperties.getMaxBinaryMessageBufferSize()));
        return container;
    }
}

