/*
 * Decompiled with CFR 0.152.
 */
package cn.suredoc.sdk.device.protocol.broadcast;

import cn.suredoc.sdk.device.protocol.broadcast.DeviceProtocolDecoder;
import cn.suredoc.sdk.device.protocol.broadcast.dto.BleRecordDto;
import cn.suredoc.sdk.device.protocol.broadcast.dto.HrRecordDetailDto;
import cn.suredoc.sdk.device.protocol.broadcast.dto.HrRecordDto;
import cn.suredoc.sdk.device.protocol.broadcast.dto.RopeRecordDetailDto;
import cn.suredoc.sdk.device.protocol.broadcast.dto.RopeRecordDto;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class EWUtils {
    private static final String timestampFormat = "yyyy/MM/dd HH:mm:ss.SSS";
    private static final String timestampShortFormat = "yyyy/MM/dd HH:mm:ss";

    public static BleRecordDto parseBleData(String jsonString) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        JSONArray jsonArray = null;
        Date uploadTime = new Date();
        JSONValidator jsonValidator = JSONValidator.from((String)jsonString);
        JSONValidator.Type type = jsonValidator.getType();
        if (type == null) {
            return null;
        }
        String gatewayMac = null;
        Date hubTime = null;
        if (type == JSONValidator.Type.Array) {
            jsonArray = JSONArray.parseArray((String)jsonString);
            JSONObject firstObj = jsonArray.getJSONObject(0);
            jsonArray.remove(0);
            if (firstObj.containsKey((Object)"id")) {
                gatewayMac = firstObj.getString("id");
                hubTime = EWUtils.parseTimestamp(firstObj.getString("time"), uploadTime);
            }
        } else if (type == JSONValidator.Type.Object) {
            JSONObject jsonData = JSONObject.parseObject((String)jsonString);
            if (!jsonData.containsKey((Object)"payload")) {
                return null;
            }
            JSONValidator payloadValidator = JSONValidator.from((String)jsonData.getString("payload"));
            if (payloadValidator.getType() == null) {
                return null;
            }
            if (jsonData.containsKey((Object)"timemills")) {
                uploadTime = new Date(jsonData.getLong("timemills"));
            }
            if (payloadValidator.getType() == JSONValidator.Type.Array) {
                jsonArray = jsonData.getJSONArray("payload");
                JSONObject firstObj = jsonArray.getJSONObject(0);
                jsonArray.remove(0);
                if (firstObj.containsKey((Object)"id")) {
                    gatewayMac = firstObj.getString("id");
                    hubTime = EWUtils.parseTimestamp(firstObj.getString("time"), uploadTime);
                }
            } else if (payloadValidator.getType() == JSONValidator.Type.Object) {
                JSONObject payloadObj = jsonData.getJSONObject("payload");
                if (payloadObj.containsKey((Object)"upload_datas")) {
                    jsonArray = payloadObj.getJSONArray("upload_datas");
                    if (payloadObj.containsKey((Object)"base_info")) {
                        JSONObject baseInfo = payloadObj.getJSONObject("base_info");
                        gatewayMac = baseInfo.getString("id");
                        hubTime = EWUtils.parseTimestamp(baseInfo.getString("time"), uploadTime);
                    }
                }
            } else {
                return null;
            }
        }
        List jsonObjectList = JSONObject.parseArray((String)jsonArray.toJSONString(), JSONObject.class);
        if (CollectionUtils.isEmpty((Collection)jsonObjectList)) {
            return null;
        }
        Date uploadTimestamp = uploadTime;
        return EWUtils.parseDeviceJsonData(jsonObjectList, uploadTimestamp, hubTime, gatewayMac);
    }

    private static BleRecordDto parseDeviceJsonData(List<JSONObject> list, Date uploadTime, Date time, String gatewayMac) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<HrRecordDetailDto> hrList = new ArrayList<HrRecordDetailDto>();
        ArrayList<HrRecordDetailDto> miopodHrList = new ArrayList<HrRecordDetailDto>();
        ArrayList<RopeRecordDetailDto> ropeList = new ArrayList<RopeRecordDetailDto>();
        for (JSONObject jsonObj : list) {
            HrRecordDetailDto lessonRealTimeHrDto;
            Serializable dto;
            String adData = jsonObj.getString("adv");
            if (StringUtils.isEmpty((CharSequence)adData)) continue;
            Integer rssi = jsonObj.getInteger("rssi");
            String mac = jsonObj.getString("mac");
            String name = DeviceProtocolDecoder.getName(adData);
            if (StringUtils.isEmpty((CharSequence)name)) continue;
            String scanData = jsonObj.getString("rsp");
            if (name.startsWith("Mio")) {
                HrRecordDto mioBandRecord = DeviceProtocolDecoder.decodeMioBandRecord(adData);
                if (mioBandRecord == null && rssi != null) {
                    dto = new HrRecordDetailDto();
                    ((HrRecordDetailDto)dto).setTime(time);
                    ((HrRecordDetailDto)dto).setRssi(rssi);
                    ((HrRecordDto)dto).setMac(mac);
                    hrList.add((HrRecordDetailDto)dto);
                    continue;
                }
                if (mioBandRecord.getHr() <= 0) continue;
                dto = EWUtils.copy(mioBandRecord, HrRecordDetailDto.class);
                ((HrRecordDetailDto)dto).setTime(time);
                if (rssi != null) {
                    ((HrRecordDetailDto)dto).setRssi(rssi);
                }
                hrList.add((HrRecordDetailDto)dto);
                continue;
            }
            if (name.startsWith("JC-")) {
                RopeRecordDto ropeData;
                if (StringUtils.isEmpty((CharSequence)scanData) || (ropeData = DeviceProtocolDecoder.decodeRopeData(scanData)) == null || ropeData.getMode() != 0 && ropeData.getMode() != 3) continue;
                dto = EWUtils.copy(ropeData, RopeRecordDetailDto.class);
                ((RopeRecordDetailDto)dto).setTime(time);
                if (rssi != null) {
                    ((RopeRecordDetailDto)dto).setRssi(rssi);
                }
                ropeList.add((RopeRecordDetailDto)dto);
                continue;
            }
            if (!name.startsWith("mioPOD") || StringUtils.isEmpty((CharSequence)scanData)) continue;
            Integer hr = DeviceProtocolDecoder.decodeMioPodHr(scanData);
            if (hr == null || hr == 0) {
                if (rssi == null) continue;
                lessonRealTimeHrDto = new HrRecordDetailDto();
                lessonRealTimeHrDto.setTime(time);
                lessonRealTimeHrDto.setRssi(rssi);
                lessonRealTimeHrDto.setMac(mac);
                miopodHrList.add(lessonRealTimeHrDto);
                continue;
            }
            lessonRealTimeHrDto = new HrRecordDetailDto();
            lessonRealTimeHrDto.setHr(hr);
            lessonRealTimeHrDto.setTime(time);
            lessonRealTimeHrDto.setMac(mac);
            if (rssi != null) {
                lessonRealTimeHrDto.setRssi(rssi);
            }
            miopodHrList.add(lessonRealTimeHrDto);
        }
        if (CollectionUtils.isEmpty(hrList) && CollectionUtils.isEmpty(ropeList) && CollectionUtils.isEmpty(miopodHrList)) {
            return null;
        }
        BleRecordDto result = new BleRecordDto();
        result.setHrList(hrList);
        result.setRopeList(ropeList);
        result.setMiopodHrList(miopodHrList);
        result.setUploadTime(uploadTime);
        result.setGatewayMac(gatewayMac);
        result.setGatewayConnectable(false);
        return result;
    }

    private static Date parseTimestamp(String timestamp) {
        if (StringUtils.isEmpty((CharSequence)timestamp)) {
            return null;
        }
        try {
            if (timestamp.length() == timestampShortFormat.length()) {
                return DateUtils.parseDate((String)timestamp, (String[])new String[]{timestampShortFormat});
            }
            return DateUtils.parseDate((String)timestamp.substring(0, timestampFormat.length()), (String[])new String[]{timestampFormat});
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static Date parseTimestamp(String timestamp, Date uploadTime) {
        Date time = EWUtils.parseTimestamp(timestamp);
        if (time == null || time.before(DateUtils.addMinutes((Date)uploadTime, (int)-5))) {
            return uploadTime;
        }
        return time;
    }

    private static <T> T copy(Object src, Class<T> clazz) {
        T result = null;
        try {
            result = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtilsBean.getInstance().getConvertUtils().register((Converter)new SqlDateConverter(null), Date.class);
            BeanUtilsBean.getInstance().getConvertUtils().register((Converter)new DateConverter(null), Date.class);
            BeanUtils.copyProperties(result, (Object)src);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

