/*
 * Decompiled with CFR 0.152.
 */
package cn.suredoc.sdk.device.protocol.broadcast;

import cn.suredoc.sdk.device.protocol.broadcast.DeviceProtocolDecoder;
import cn.suredoc.sdk.device.protocol.broadcast.EWUtils;
import cn.suredoc.sdk.device.protocol.broadcast.dto.BleRecordDto;
import cn.suredoc.sdk.device.protocol.broadcast.dto.HrRecordDetailDto;
import cn.suredoc.sdk.device.protocol.broadcast.dto.HrRecordDto;
import cn.suredoc.sdk.device.protocol.broadcast.dto.RopeRecordDetailDto;
import cn.suredoc.sdk.device.protocol.broadcast.dto.RopeRecordDto;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DeviceProtocolUtils {
    public static final String DEFAULT_MIOBAND_NAME_REGEX = "Mio .*";
    public static final String DEFAULT_ROPE_NAME_REGEX = "JC-.*";
    public static final String DEFAULT_MIOPOD_NAME_REGEX = "mioPOD .*";

    public static BleRecordDto parseBleData(String jsonString) {
        return DeviceProtocolUtils.parseBleData(jsonString, DEFAULT_MIOBAND_NAME_REGEX, DEFAULT_ROPE_NAME_REGEX, DEFAULT_MIOPOD_NAME_REGEX);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BleRecordDto parseBleData(String jsonString, String miobandRegex, String ropeNameRegex, String miopodNameRegex) {
        String gatewayMac;
        JSONObject jsonData;
        Date uploadTime;
        JSONArray jsonArray;
        block20: {
            if (StringUtils.isEmpty((CharSequence)jsonString)) {
                return null;
            }
            if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{miobandRegex, ropeNameRegex, miopodNameRegex})) {
                throw new IllegalArgumentException("regex is required.");
            }
            jsonArray = null;
            uploadTime = new Date();
            jsonData = null;
            JSONValidator jsonValidator = JSONValidator.from((String)jsonString);
            JSONValidator.Type type = jsonValidator.getType();
            if (type == null) {
                return null;
            }
            gatewayMac = null;
            if (type == JSONValidator.Type.Array) {
                jsonArray = JSONArray.parseArray((String)jsonString);
            } else if (type == JSONValidator.Type.Object) {
                jsonData = JSONObject.parseObject((String)jsonString);
                if (jsonData.containsKey((Object)"payload")) {
                    JSONValidator payloadValidator;
                    if (jsonData.containsKey((Object)"timemills")) {
                        uploadTime = new Date(jsonData.getLong("timemills"));
                    }
                    if (jsonData.containsKey((Object)"devicename")) {
                        gatewayMac = jsonData.getString("devicename");
                    }
                    if ((payloadValidator = JSONValidator.from((String)jsonData.getString("payload"))).getType() == null) {
                        return null;
                    }
                    if (payloadValidator.getType() == JSONValidator.Type.Array) {
                        jsonArray = jsonData.getJSONArray("payload");
                        break block20;
                    } else {
                        if (payloadValidator.getType() == JSONValidator.Type.Object) {
                            return EWUtils.parseBleData(jsonString);
                        }
                        return null;
                    }
                }
                if (jsonData.containsKey((Object)"action") && StringUtils.equals((CharSequence)"data.scan", (CharSequence)jsonData.getString("action"))) {
                    if (!jsonData.containsKey((Object)"data")) {
                        return null;
                    }
                    if (jsonData.containsKey((Object)"gateway")) {
                        gatewayMac = jsonData.getString("gateway").replaceAll(":", "");
                    }
                    jsonArray = jsonData.getJSONArray("data");
                } else {
                    return null;
                }
            }
        }
        List jsonObjectList = JSONObject.parseArray((String)jsonArray.toJSONString(), JSONObject.class);
        if (CollectionUtils.isEmpty((Collection)jsonObjectList)) {
            return null;
        }
        JSONObject firstObj = (JSONObject)jsonObjectList.get(0);
        if (firstObj.containsKey((Object)"id") && (jsonData == null || !jsonData.containsKey((Object)"action"))) {
            return EWUtils.parseBleData(jsonString);
        }
        Date uploadTimestamp = uploadTime;
        ArrayList<HrRecordDetailDto> hrList = new ArrayList<HrRecordDetailDto>();
        ArrayList<HrRecordDetailDto> miopodHrList = new ArrayList<HrRecordDetailDto>();
        ArrayList<RopeRecordDetailDto> ropeList = new ArrayList<RopeRecordDetailDto>();
        jsonObjectList.stream().collect(Collectors.groupingBy(json -> json.getString("name"))).forEach((k, v) -> {
            BleRecordDto dealDeviceClassData = DeviceProtocolUtils.parseDeviceJsonDataByName(miobandRegex, ropeNameRegex, miopodNameRegex, k, v, uploadTimestamp);
            if (dealDeviceClassData != null && !CollectionUtils.isEmpty(dealDeviceClassData.getHrList())) {
                hrList.addAll(dealDeviceClassData.getHrList());
            }
            if (dealDeviceClassData != null && !CollectionUtils.isEmpty(dealDeviceClassData.getMiopodHrList())) {
                miopodHrList.addAll(dealDeviceClassData.getMiopodHrList());
            }
            if (dealDeviceClassData != null && !CollectionUtils.isEmpty(dealDeviceClassData.getRopeList())) {
                ropeList.addAll(dealDeviceClassData.getRopeList());
            }
        });
        if (CollectionUtils.isEmpty(hrList) && CollectionUtils.isEmpty(miopodHrList) && CollectionUtils.isEmpty(ropeList)) {
            return null;
        }
        BleRecordDto result = new BleRecordDto();
        result.setHrList(hrList);
        result.setRopeList(ropeList);
        result.setMiopodHrList(miopodHrList);
        result.setUploadTime(uploadTime);
        result.setGatewayMac(gatewayMac);
        result.setGatewayConnectable(true);
        return result;
    }

    private static BleRecordDto parseDeviceJsonDataByName(String miobandRegex, String ropeNameRegex, String miopodNameRegex, String name, List<JSONObject> list, Date uploadTime) {
        if (StringUtils.isEmpty((CharSequence)name) || CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<HrRecordDetailDto> hrList = new ArrayList<HrRecordDetailDto>();
        List<RopeRecordDetailDto> ropeDataList = null;
        ArrayList<HrRecordDetailDto> mioPodDataList = new ArrayList();
        if (Pattern.matches(miobandRegex, name)) {
            List<HrRecordDetailDto> bandDataList = DeviceProtocolUtils.parseMioBandData(list, uploadTime);
            if (!CollectionUtils.isEmpty(bandDataList)) {
                hrList.addAll(bandDataList);
            }
        } else if (Pattern.matches(ropeNameRegex, name)) {
            ropeDataList = DeviceProtocolUtils.parseRopeData(list, uploadTime);
        } else if (Pattern.matches(miopodNameRegex, name)) {
            mioPodDataList = DeviceProtocolUtils.parseMiopodData(list, uploadTime);
        }
        if (CollectionUtils.isEmpty(hrList) && CollectionUtils.isEmpty(ropeDataList) && CollectionUtils.isEmpty(mioPodDataList)) {
            return null;
        }
        BleRecordDto data = new BleRecordDto();
        data.setRopeList(ropeDataList);
        data.setHrList(hrList);
        data.setMiopodHrList(mioPodDataList);
        return data;
    }

    private static Date parseTimestamp(String timestamp) {
        if (StringUtils.isEmpty((CharSequence)timestamp)) {
            return null;
        }
        if (timestamp.endsWith("CST")) {
            try {
                return DateUtils.parseDate((String)timestamp.substring(0, timestamp.length() - 4), (String[])new String[]{"yyyy-MM-dd HH:mm:ss.SSS"});
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (timestamp.endsWith("GMT")) {
            try {
                return DateUtils.addHours((Date)DateUtils.parseDate((String)timestamp.substring(0, timestamp.length() - 4), (String[])new String[]{"yyyy-MM-dd HH:mm:ss.SSS"}), (int)8);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    private static Date parseTimestamp(String timestamp, Date uploadTime) {
        Date time = DeviceProtocolUtils.parseTimestamp(timestamp);
        if (time == null || time.before(DateUtils.addMinutes((Date)uploadTime, (int)-5))) {
            return uploadTime;
        }
        return time;
    }

    private static List<HrRecordDetailDto> parseMioBandData(List<JSONObject> jsonData, Date uploadTime) {
        if (jsonData == null || jsonData.isEmpty()) {
            return null;
        }
        ArrayList<HrRecordDetailDto> hrList = new ArrayList<HrRecordDetailDto>();
        for (JSONObject jsonObj : jsonData) {
            HrRecordDetailDto dto;
            List jsonObjectList;
            String bdaddr;
            Date time = DeviceProtocolUtils.parseTimestamp(jsonObj.getString("timestamp"), uploadTime);
            String adData = jsonObj.getString("adData");
            if (StringUtils.isEmpty((CharSequence)adData)) continue;
            HrRecordDto mioBandRecord = DeviceProtocolDecoder.decodeMioBandRecord(adData);
            Integer rssi = jsonObj.getInteger("rssi");
            JSONArray bdaddrs = jsonObj.getJSONArray("bdaddrs");
            if (CollectionUtils.isEmpty((Collection)bdaddrs) || StringUtils.isEmpty((CharSequence)(bdaddr = ((JSONObject)(jsonObjectList = JSONObject.parseArray((String)bdaddrs.toJSONString(), JSONObject.class)).get(0)).getString("bdaddr")))) continue;
            String mac = bdaddr.replaceAll(":", "");
            if (mioBandRecord == null && rssi != null) {
                dto = new HrRecordDetailDto();
                dto.setTime(time);
                dto.setRssi(rssi);
                dto.setMac(mac);
                hrList.add(dto);
                continue;
            }
            if (mioBandRecord.getHr() <= 0) continue;
            dto = DeviceProtocolUtils.copy(mioBandRecord, HrRecordDetailDto.class);
            dto.setTime(time);
            if (rssi != null) {
                dto.setRssi(rssi);
            }
            hrList.add(dto);
        }
        return hrList;
    }

    private static List<RopeRecordDetailDto> parseRopeData(List<JSONObject> jsonData, Date uploadTime) {
        if (jsonData == null || jsonData.isEmpty()) {
            return null;
        }
        ArrayList<RopeRecordDetailDto> ropeList = new ArrayList<RopeRecordDetailDto>();
        for (JSONObject ropeJson : jsonData) {
            RopeRecordDto ropeData;
            Date time = DeviceProtocolUtils.parseTimestamp(ropeJson.getString("timestamp"), uploadTime);
            String scanData = ropeJson.getString("scanData");
            String adData = ropeJson.getString("adData");
            if (StringUtils.isEmpty((CharSequence)scanData) && StringUtils.isEmpty((CharSequence)adData) || (ropeData = DeviceProtocolDecoder.decodeRopeData(scanData)) == null && (ropeData = DeviceProtocolDecoder.decodeRopeData(adData)) == null) continue;
            RopeRecordDetailDto dto = DeviceProtocolUtils.copy(ropeData, RopeRecordDetailDto.class);
            dto.setTime(time);
            Integer rssi = ropeJson.getInteger("rssi");
            if (rssi != null) {
                dto.setRssi(rssi);
            }
            ropeList.add(dto);
        }
        return ropeList;
    }

    private static List<HrRecordDetailDto> parseMiopodData(List<JSONObject> mioPODList, Date uploadTime) {
        if (mioPODList == null || mioPODList.isEmpty()) {
            return null;
        }
        ArrayList<HrRecordDetailDto> hrList = new ArrayList<HrRecordDetailDto>();
        for (JSONObject mioPODJson : mioPODList) {
            HrRecordDetailDto lessonRealTimeHrDto;
            String mac;
            List jsonObjectList;
            String bdaddr;
            JSONArray bdaddrs;
            Date time = DeviceProtocolUtils.parseTimestamp(mioPODJson.getString("timestamp"), uploadTime);
            String scanData = mioPODJson.getString("scanData");
            if (StringUtils.isEmpty((CharSequence)scanData) || CollectionUtils.isEmpty((Collection)(bdaddrs = mioPODJson.getJSONArray("bdaddrs"))) || StringUtils.isEmpty((CharSequence)(bdaddr = ((JSONObject)(jsonObjectList = JSONObject.parseArray((String)bdaddrs.toJSONString(), JSONObject.class)).get(0)).getString("bdaddr"))) || StringUtils.isEmpty((CharSequence)(mac = bdaddr.replaceAll(":", "")))) continue;
            Integer hr = DeviceProtocolDecoder.decodeMioPodHr(scanData);
            Integer rssi = mioPODJson.getInteger("rssi");
            if (hr == null || hr == 0) {
                if (rssi == null) continue;
                lessonRealTimeHrDto = new HrRecordDetailDto();
                lessonRealTimeHrDto.setTime(time);
                lessonRealTimeHrDto.setRssi(rssi);
                lessonRealTimeHrDto.setMac(mac);
                hrList.add(lessonRealTimeHrDto);
                continue;
            }
            lessonRealTimeHrDto = new HrRecordDetailDto();
            lessonRealTimeHrDto.setHr(hr);
            lessonRealTimeHrDto.setTime(time);
            lessonRealTimeHrDto.setMac(mac);
            if (rssi != null) {
                lessonRealTimeHrDto.setRssi(rssi);
            }
            hrList.add(lessonRealTimeHrDto);
        }
        return hrList;
    }

    private static <T> T copy(Object src, Class<T> clazz) {
        T result = null;
        try {
            result = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtilsBean.getInstance().getConvertUtils().register((Converter)new SqlDateConverter(null), Date.class);
            BeanUtilsBean.getInstance().getConvertUtils().register((Converter)new DateConverter(null), Date.class);
            BeanUtils.copyProperties(result, (Object)src);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

