/*
 * Decompiled with CFR 0.152.
 */
package cn.suredoc.sdk.device.protocol.broadcast;

import cn.suredoc.sdk.device.protocol.broadcast.dto.HrRecordDto;
import cn.suredoc.sdk.device.protocol.broadcast.dto.RopeRecordDto;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

class DeviceProtocolDecoder {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    DeviceProtocolDecoder() {
    }

    public static byte[] toByteArray(String hex) {
        try {
            return Hex.decodeHex((char[])hex.toCharArray());
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toHex(byte[] bytes) {
        return Hex.encodeHexString((byte[])bytes).toUpperCase();
    }

    public static ByteBuf getDefaultByteBuf() {
        return UnpooledByteBufAllocator.DEFAULT.buffer();
    }

    public static void release(ByteBuf byteBuf) {
        if (byteBuf == null) {
            return;
        }
        try {
            byteBuf.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static RopeRecordDto decodeRopeData(String scanData) {
        if (StringUtils.isEmpty((CharSequence)scanData) || scanData.length() < 44) {
            return null;
        }
        ByteBuf cmdByteBuf = null;
        try {
            cmdByteBuf = DeviceProtocolDecoder.getDefaultByteBuf();
            cmdByteBuf.writeBytes(DeviceProtocolDecoder.toByteArray(scanData));
            short dataLength = cmdByteBuf.readUnsignedByte();
            if (dataLength < 22) {
                RopeRecordDto ropeRecordDto = null;
                return ropeRecordDto;
            }
            RopeRecordDto result = new RopeRecordDto();
            short type = cmdByteBuf.readUnsignedByte();
            if (type != 255) {
                RopeRecordDto ropeRecordDto = null;
                return ropeRecordDto;
            }
            short head = cmdByteBuf.readUnsignedByte();
            if (head != 252) {
                RopeRecordDto ropeRecordDto = null;
                return ropeRecordDto;
            }
            short protocol = cmdByteBuf.readUnsignedByte();
            byte[] macArr = new byte[6];
            cmdByteBuf.readBytes(macArr);
            ArrayUtils.reverse((byte[])macArr);
            String mac = DeviceProtocolDecoder.toHex(macArr).toUpperCase();
            result.setMac(mac);
            short mode = cmdByteBuf.readUnsignedByte();
            result.setMode(mode);
            switch (protocol) {
                case 162: {
                    RopeRecordDto ropeRecordDto = DeviceProtocolDecoder.decode0xa2(cmdByteBuf, protocol, mode, result);
                    return ropeRecordDto;
                }
            }
            RopeRecordDto ropeRecordDto = DeviceProtocolDecoder.decode0xa0a1(cmdByteBuf, protocol, mode, result);
            return ropeRecordDto;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DeviceProtocolDecoder.release(cmdByteBuf);
        }
    }

    private static RopeRecordDto decode0xa2(ByteBuf cmdByteBuf, short protocol, int mode, RopeRecordDto result) {
        long beginTime = cmdByteBuf.readUnsignedIntLE();
        result.setBeginTime(beginTime);
        int nums = cmdByteBuf.readUnsignedShortLE();
        result.setNums(nums);
        short status = cmdByteBuf.readUnsignedByte();
        result.setEnd(status == 5);
        ArrayList<Integer> historyNums = new ArrayList<Integer>();
        result.setHistoryNums(historyNums);
        while (cmdByteBuf.readableBytes() > 3) {
            String paddedBS = StringUtils.leftPad((String)Integer.toBinaryString(cmdByteBuf.readUnsignedByte()), (int)8, (String)"0");
            historyNums.add(Integer.parseUnsignedInt(paddedBS.substring(0, 4), 2));
            historyNums.add(Integer.parseUnsignedInt(paddedBS.substring(4, 8), 2));
        }
        ArrayList<Integer> historyTripWireNums = new ArrayList<Integer>();
        result.setHistoryTripWireNums(historyTripWireNums);
        while (cmdByteBuf.readableBytes() > 0) {
            String paddedBS = StringUtils.leftPad((String)Integer.toBinaryString(cmdByteBuf.readUnsignedByte()), (int)8, (String)"0");
            for (int i = 0; i < 8; ++i) {
                historyTripWireNums.add(Integer.parseUnsignedInt(paddedBS.substring(i, i + 1), 2));
            }
        }
        return result;
    }

    private static RopeRecordDto decode0xa0a1(ByteBuf cmdByteBuf, short protocol, int mode, RopeRecordDto result) {
        int setting = cmdByteBuf.readUnsignedShortLE();
        if (mode == 0) {
            result.setTotalTimeSetting(setting);
        } else if (mode == 1) {
            result.setNumsSetting(setting);
        }
        long beginTime = cmdByteBuf.readUnsignedIntLE();
        result.setBeginTime(beginTime);
        int sumTimeData = cmdByteBuf.readUnsignedShortLE();
        result.setTotalTime(sumTimeData);
        int nums = cmdByteBuf.readUnsignedShortLE();
        result.setNums(nums);
        int effectiveTime = cmdByteBuf.readUnsignedShortLE();
        result.setEffectiveTime(effectiveTime);
        short deviceStatus = cmdByteBuf.readUnsignedByte();
        if (protocol == 160) {
            result.setEnd(beginTime != 0L);
        } else if (mode == 0) {
            result.setEnd(result.getTotalTime() == result.getTotalTimeSetting() || deviceStatus == 5);
        } else {
            result.setEnd(deviceStatus == 5);
        }
        if (!cmdByteBuf.isReadable()) {
            return result;
        }
        if (mode == 0 && cmdByteBuf.readableBytes() >= 6) {
            short frontTripWire = cmdByteBuf.readUnsignedByte();
            result.setFrontTripWire(Integer.valueOf(frontTripWire));
            short frontNums = cmdByteBuf.readUnsignedByte();
            result.setFrontNums(Integer.valueOf(frontNums));
            short middleTripWire = cmdByteBuf.readUnsignedByte();
            result.setMiddleTripWire(Integer.valueOf(middleTripWire));
            short middleNums = cmdByteBuf.readUnsignedByte();
            result.setMiddleNums(Integer.valueOf(middleNums));
            short backTripWire = cmdByteBuf.readUnsignedByte();
            result.setBackTripWire(Integer.valueOf(backTripWire));
            short backNums = cmdByteBuf.readUnsignedByte();
            result.setBackNums(Integer.valueOf(backNums));
        }
        return result;
    }

    public static Integer decodeMioPodHr(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return null;
        }
        if (data.length() != 12) {
            return null;
        }
        ByteBuf cmdByteBuf = null;
        try {
            cmdByteBuf = DeviceProtocolDecoder.getDefaultByteBuf();
            cmdByteBuf.writeBytes(DeviceProtocolDecoder.toByteArray(data));
            cmdByteBuf.readByte();
            cmdByteBuf.readByte();
            cmdByteBuf.readShort();
            byte valid = cmdByteBuf.readByte();
            if (0 == valid) {
                Integer n = null;
                return n;
            }
            short hr = cmdByteBuf.readUnsignedByte();
            Integer n = hr;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DeviceProtocolDecoder.release(cmdByteBuf);
        }
    }

    public static HrRecordDto decodeMioBandRecord(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        if (data.length() < 50 || !data.startsWith("020106")) {
            return null;
        }
        ByteBuf cmdByteBuf = null;
        try {
            cmdByteBuf = DeviceProtocolDecoder.getDefaultByteBuf();
            cmdByteBuf.writeBytes(DeviceProtocolDecoder.toByteArray(data));
            cmdByteBuf.readByte();
            cmdByteBuf.readShort();
            byte dataLength = cmdByteBuf.readByte();
            HrRecordDto result = new HrRecordDto();
            if (15 == dataLength) {
                cmdByteBuf.readByte();
                cmdByteBuf.readShortLE();
                byte[] macArr = new byte[6];
                cmdByteBuf.readBytes(macArr);
                String mac = DeviceProtocolDecoder.toHex(macArr).toUpperCase();
                result.setMac(mac);
                int cal = cmdByteBuf.readUnsignedShortLE();
                result.setCalorie(cal);
                short hr = cmdByteBuf.readUnsignedByte();
                result.setHr(hr);
                short hrMax = cmdByteBuf.readUnsignedByte();
                result.setHrMax(Integer.valueOf(hrMax));
                int seconds = cmdByteBuf.readUnsignedShortLE();
                result.setSeconds(seconds);
                HrRecordDto hrRecordDto = result;
                return hrRecordDto;
            }
            if (dataLength == 13) {
                cmdByteBuf.readByte();
                byte[] macArr = new byte[6];
                cmdByteBuf.readBytes(macArr);
                String mac = DeviceProtocolDecoder.toHex(macArr).toUpperCase();
                result.setMac(mac);
                int cal = cmdByteBuf.readUnsignedShortLE();
                result.setCalorie(cal);
                short hr = cmdByteBuf.readUnsignedByte();
                result.setHr(hr);
                short hrMax = cmdByteBuf.readUnsignedByte();
                result.setHrMax(Integer.valueOf(hrMax));
                int seconds = cmdByteBuf.readUnsignedShortLE();
                result.setSeconds(seconds);
                HrRecordDto hrRecordDto = result;
                return hrRecordDto;
            }
            HrRecordDto hrRecordDto = null;
            return hrRecordDto;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DeviceProtocolDecoder.release(cmdByteBuf);
        }
    }

    public static String getName(String data) {
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        ByteBuf cmdByteBuf = null;
        String name = null;
        try {
            cmdByteBuf = DeviceProtocolDecoder.getDefaultByteBuf();
            cmdByteBuf.writeBytes(DeviceProtocolDecoder.toByteArray(data));
            while (cmdByteBuf.readableBytes() > 0) {
                short dataLength = cmdByteBuf.readUnsignedByte();
                short dataType = cmdByteBuf.readUnsignedByte();
                byte[] dataBuf = new byte[dataLength - 1];
                cmdByteBuf.readBytes(dataBuf);
                if (dataType != 9) continue;
                name = new String(dataBuf);
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DeviceProtocolDecoder.release(cmdByteBuf);
        }
        return name;
    }
}

