package cn.suredoc.sdk.device.protocol.broadcast.dto;

import java.io.Serializable;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class RopeRecordDto implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -677287897375356510L;
	/**
	 * 倒计时模式
	 */
	public static final int COUNT_DOWN_TIME_MODE = 0;
	/**
	 * 倒计数模式
	 */
	public static final int COUNT_DOWN_MODE = 1;
	/**
	 * 自由跳模式
	 */
	public static final int FREE_MODE = 2;
	/**
	 * 团队测试模式
	 */
	public static final int ACCUMULATIVE_TOTAL_MODE = 3;

	/**
	 * 设备mac
	 */
	private String mac;
	/**
	 * 跳绳次数
	 */
	private int nums;
	/**
	 * 跳绳总时长，单位：秒（A0版本）
	 */
	private int totalTime;
	/**
	 * 有效运动时长，单位：秒（A0版本）
	 */
	private int seconds;
	/**
	 * 模式，0：倒计时跳，1：倒计数跳，2：自由跳，3：团队测试
	 */
	private int mode;
	/**
	 * 设置的倒计时跳时间，单位：秒（A0版本）
	 */
	private int totalTimeSetting;
	/**
	 * 设置的倒计数跳次数（A0版本）
	 */
	private int numsSetting;
	/**
	 * 跳绳结束标识
	 */
	private boolean end;
	/**
	 * A0版本开始跳绳时间戳，A2版本为设备时间戳
	 */
	private long beginTime;
	/**
	 * 跳绳有效时长（A0版本）
	 */
	private int effectiveTime;
	/**
	 * 前20秒绊绳次数（A0版本倒计时一分钟模式）
	 */
	private int frontTripWire;
	/**
	 * 前20秒跳绳个数（A0版本倒计时一分钟模式）
	 */
	private int frontNums;
	/**
	 * 中间20绊绳次数（A0版本倒计时一分钟模式）
	 */
	private int middleTripWire;
	/**
	 * 中间20秒跳绳个数（A0版本倒计时一分钟模式）
	 */
	private int middleNums;
	/**
	 * 最后20秒绊绳次数（A0版本倒计时一分钟模式）
	 */
	private int backTripWire;
	/**
	 * 最后20秒跳绳个数（A0版本倒计时一分钟模式）
	 */
	private int backNums;
	/**
	 * 历史每秒跳绳个数（A2版本团队测试模式），索引=0为当前秒跳绳次数，后面的数据依次往前倒推，共20个数
	 */
	private List<Integer> historyNums;
	/**
	 * 历史每秒绊绳个数（A2版本团队测试模式），索引=0为当前秒绊绳次数，后面的数据依次往前倒推，共24个数
	 */
	private List<Integer> historyTripWireNums;
}
