package cn.suredoc.sdk.device.protocol.base.utils;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONObject;

/**
 * json 工具类
 * 
 * @author
 * 
 */
public class JsonUtils {

	/**
	 * 转换为JSON字符串
	 * 
	 * @param obj 对象
	 * @return
	 */
	public static String toJson(Object obj) {
		if (obj == null) {
			return null;
		}
		return JSONObject.toJSONString(obj);
	}

	/**
	 * json 转 javabean
	 * 
	 * @param json  JSON字符串
	 * @param clazz 要转换的目标类型
	 * @return
	 */
	public static <T> T toBean(String json, Class<T> clazz) {
		if (StringUtils.isEmpty(json)) {
			return null;
		}
		try {
			return JSONObject.parseObject(json, clazz);
		} catch (Exception e) {
			throw new RuntimeException("转换json发生异常", e);
		}
	}
}
