package cn.suredoc.sdk.device.protocol.base.utils;

import java.io.UnsupportedEncodingException;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class HexUtils {

	/**
	 * 将十六进制字符串转换为字节数组
	 * 
	 * @param hex 十六进制字符串
	 * @return
	 */
	public static byte[] toByteArray(String hex) {
		try {
			return Hex.decodeHex(hex.toCharArray());
		} catch (DecoderException e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * 将字节数组转换为十六进制字符串
	 * 
	 * @param bytes 字节流
	 * @return
	 */
	public static String toHex(byte[] bytes) {
		return Hex.encodeHexString(bytes).toUpperCase();
	}

	/**
	 * 将十六进制字符数组转换为字符串，编码UTF-8
	 * 
	 * @param hex 十六进制字符串
	 * @return
	 */
	public static String decodeHexStr(String hex) {
		try {
			return new String(toByteArray(hex), "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}
}
