/*
 * Decompiled with CFR 0.152.
 */
package cn.suredoc.sdk.device.protocol.base.utils;

import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class SignatureUtils {
    public static boolean isValidSignature(String signature, String token, String timestamp, String nonce) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{signature, token, timestamp, nonce})) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)SignatureUtils.generateSignature(token, timestamp, nonce), (CharSequence)signature);
    }

    public static String generateSignature(String token, String timestamp, String nonce) {
        Object[] tmpArr = new String[]{token, timestamp, nonce};
        Arrays.sort(tmpArr);
        String tmpStr = SignatureUtils.arrayToString((String[])tmpArr);
        return SignatureUtils.SHA1Encode(tmpStr);
    }

    public static String generateSignature(String[] strArr) {
        Arrays.sort(strArr);
        String tmpStr = SignatureUtils.arrayToString(strArr);
        return SignatureUtils.SHA1Encode(tmpStr);
    }

    private static String arrayToString(String[] arr) {
        StringBuffer bf = new StringBuffer();
        for (String str : arr) {
            bf.append(str);
        }
        return bf.toString();
    }

    private static String SHA1Encode(String sourceString) {
        String resultString = null;
        try {
            resultString = new String(sourceString);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            resultString = SignatureUtils.byte2hexString(md.digest(resultString.getBytes()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return resultString;
    }

    private static String byte2hexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Integer.toString(bytes[i] & 0xFF, 16));
        }
        return buf.toString().toLowerCase();
    }
}

