/*
 * Decompiled with CFR 0.152.
 */
package cn.suredoc.sdk.device.protocol.base.utils;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);

    private HttpClientUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Connection", "close");
        String body = null;
        try {
            httpGet.setURI(new URI(httpGet.getURI().toString()));
            httpGet.setConfig(defaultRequestConfig);
            CloseableHttpResponse httpResponse = HttpClientUtils.getHttpclient().execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            body = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error("httt_wechatsend_get_error_requestId_url:" + url + " error:" + e.getMessage(), (Throwable)e);
        }
        finally {
            httpGet.abort();
            httpGet.releaseConnection();
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, Object> params) {
        HttpGet httpGet = null;
        String body = null;
        try {
            if (MapUtils.isNotEmpty(params)) {
                ArrayList entityParams = new ArrayList(params.size());
                params.forEach((key, value) -> entityParams.add(new BasicNameValuePair(key, (String)value)));
                String paramsUrl = EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(entityParams, Consts.UTF_8));
                url = url + "?" + paramsUrl;
            }
            httpGet = new HttpGet(url);
            httpGet.setHeader("Connection", "close");
            httpGet.setURI(new URI(httpGet.getURI().toString()));
            httpGet.setConfig(defaultRequestConfig);
            CloseableHttpResponse httpResponse = HttpClientUtils.getHttpclient().execute((HttpUriRequest)httpGet);
            HttpEntity entity = httpResponse.getEntity();
            body = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error("httt_wechatsend_get_error_requestId_url:" + url + " error:" + e.getMessage(), (Throwable)e);
        }
        finally {
            httpGet.abort();
            httpGet.releaseConnection();
        }
        return body;
    }

    public static String post(String url, String params) {
        return HttpClientUtils.post(url, params, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String params, Map<String, String> headers) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(defaultRequestConfig);
        httpPost.setHeader("Connection", "close");
        if (headers != null && !headers.isEmpty()) {
            Set<String> keySet = headers.keySet();
            for (String key : keySet) {
                String value = headers.get(key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                httpPost.addHeader(key, value);
            }
        }
        String body = null;
        try {
            CloseableHttpResponse httpResponse;
            HttpEntity entity;
            if (!StringUtils.isEmpty((CharSequence)params)) {
                StringEntity se = new StringEntity(params, Consts.UTF_8);
                se.setContentType("application/json");
                httpPost.setEntity((HttpEntity)se);
            }
            if ((entity = (httpResponse = HttpClientUtils.getHttpclient().execute((HttpUriRequest)httpPost)).getEntity()) != null) {
                body = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error("url:" + url + " error:" + e.getMessage(), (Throwable)e);
        }
        finally {
            httpPost.abort();
            httpPost.releaseConnection();
        }
        return body;
    }

    public static String delete(String url) {
        return HttpClientUtils.delete(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String delete(String url, Map<String, String> headers) {
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.setConfig(defaultRequestConfig);
        httpDelete.setHeader("Connection", "close");
        if (headers != null && !headers.isEmpty()) {
            Set<String> keySet = headers.keySet();
            for (String key : keySet) {
                String value = headers.get(key);
                if (StringUtils.isEmpty((CharSequence)value)) continue;
                httpDelete.addHeader(key, value);
            }
        }
        String body = null;
        try {
            CloseableHttpResponse httpResponse = HttpClientUtils.getHttpclient().execute((HttpUriRequest)httpDelete);
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                body = EntityUtils.toString((HttpEntity)entity, (Charset)Consts.UTF_8);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            logger.error("url:" + url + " error:" + e.getMessage(), (Throwable)e);
        }
        finally {
            httpDelete.abort();
            httpDelete.releaseConnection();
        }
        return body;
    }

    public static CloseableHttpClient getHttpclient() {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        return httpclient;
    }
}

