package cn.suredoc.sdk.device.protocol.base.utils;

import java.security.MessageDigest;
import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;

/**
 * 签名工具类
 * 
 * @author
 *
 */
public class SignatureUtils {

	/**
	 * 数字签名是否合法
	 * 
	 * @param signature 数字签名
	 * @param token     访问令牌
	 * @param timestamp 时间戳
	 * @param nonce     随机数
	 * @return 是否合法
	 */
	public static boolean isValidSignature(String signature, String token, String timestamp, String nonce) {
		if (StringUtils.isAnyBlank(signature, token, timestamp, nonce)) {
			return false;
		}
		return StringUtils.equalsIgnoreCase(generateSignature(token, timestamp, nonce), signature);

	}

	/**
	 * 生成数字签名
	 * 
	 * @param token     访问令牌
	 * @param timestamp 时间戳
	 * @param nonce     随机数
	 * @return 签名
	 */
	public static String generateSignature(String token, String timestamp, String nonce) {
		// 这里的token是个人端登录或注册用户时生成，在需要验证登录的接口中传入此token
		String[] tmpArr = { token, timestamp, nonce };
		// 将token、timestamp、nonce三个参数进行字典序排序
		Arrays.sort(tmpArr);
		// 将三个参数字符串拼接成一个字符串
		String tmpStr = arrayToString(tmpArr);
		return SHA1Encode(tmpStr);
	}

	/**
	 * 计算签名
	 * 
	 * @param strArr 字符串数组
	 * @return 签名
	 */
	public static String generateSignature(String[] strArr) {
		// 参数进行字典序排序
		Arrays.sort(strArr);
		// 拼接成一个字符串
		String tmpStr = arrayToString(strArr);
		return SHA1Encode(tmpStr);
	}

	// 数组转字符串
	private static String arrayToString(String[] arr) {
		StringBuffer bf = new StringBuffer();
		for (String str : arr) {
			bf.append(str);
		}
		return bf.toString();
	}

	// 进行sha1加密
	private static String SHA1Encode(String sourceString) {
		String resultString = null;
		try {
			resultString = new String(sourceString);
			MessageDigest md = MessageDigest.getInstance("SHA-1");
			resultString = byte2hexString(md.digest(resultString.getBytes()));
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return resultString;
	}

	private static String byte2hexString(byte[] bytes) {
		StringBuffer buf = new StringBuffer(bytes.length * 2);
		for (int i = 0; i < bytes.length; i++) {
			if (((int) bytes[i] & 0xff) < 0x10) {
				buf.append("0");
			}
			buf.append(Integer.toString((int) bytes[i] & 0xff, 16));
		}
		return buf.toString().toLowerCase();
	}

}
