package cn.suredoc.sdk.device.protocol.base.utils;

import java.util.zip.CRC32;

import org.apache.commons.lang3.StringUtils;

public class CrcUtils {

	/**
	 * crc32
	 * 
	 * @param str 字符串
	 * @return
	 */
	public static long crc32(String str) {
		if (StringUtils.isEmpty(str)) {
			throw new IllegalArgumentException("str is empty");
		}
		return crc32(str.getBytes());
	}

	/**
	 * crc32
	 * 
	 * @param bytes 字节流
	 * @return
	 */
	public static long crc32(byte[] bytes) {
		if (bytes == null || bytes.length == 0) {
			throw new IllegalArgumentException("bytes is empty");
		}
		CRC32 crc32 = new CRC32();
		crc32.update(bytes);
		return crc32.getValue();
	}

}
