/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.cglib.beans.BeanGenerator;

public class DynamicObject {
    private Object dynamicBean;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    Class clazz;

    public DynamicObject(Object object) {
        this.dynamicBean = this.generateBean(this.getFields(object));
        Map<String, Object> values = this.getValues(object);
        for (String key : values.keySet()) {
            Object value = values.get(key);
            this.put(key, value);
        }
        this.clazz = this.dynamicBean.getClass();
    }

    public static DynamicObject parseMap(Map<String, Object> targetMap) {
        DynamicObject dynamicObject = new DynamicObject();
        for (Map.Entry<String, Object> entry : targetMap.entrySet()) {
            dynamicObject.put(entry.getKey(), entry.getValue());
        }
        return dynamicObject;
    }

    public static DynamicObject parseString(String jsonString) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
        return DynamicObject.parseMap((Map<String, Object>)jsonObject);
    }

    public Map<String, Object> getValues() {
        HashMap<String, Object> fieldValuesMap = new HashMap<String, Object>(16);
        if (this.clazz != null) {
            Field[] fields;
            for (Field field : fields = this.clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(this.dynamicBean);
                    fieldValuesMap.put(field.getName().split("\\$cglib_prop_")[1], fieldValue);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return fieldValuesMap;
        }
        return fieldValuesMap;
    }

    public Map<String, Object> getValues(Object object) {
        HashMap<String, Object> fieldValuesMap = new HashMap<String, Object>(16);
        Class<?> clazz = object.getClass();
        if (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(object);
                    fieldValuesMap.put(field.getName(), fieldValue);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return fieldValuesMap;
        }
        return fieldValuesMap;
    }

    public void put(String property, Object value) {
        Field declaredField;
        try {
            declaredField = this.clazz.getDeclaredField("$cglib_prop_" + property);
        }
        catch (Exception e) {
            Map<String, Class<?>> fields = this.getFields();
            fields.put(property, Object.class);
            Map<String, Object> values = this.getValues();
            this.dynamicBean = this.generateBean(fields);
            this.clazz = this.dynamicBean.getClass();
            values.put(property, value);
            for (String putKey : values.keySet()) {
                Object putValue = values.get(putKey);
                try {
                    Field field = this.clazz.getDeclaredField("$cglib_prop_" + putKey);
                    field.setAccessible(true);
                    field.set(this.dynamicBean, putValue);
                }
                catch (IllegalAccessException | NoSuchFieldException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return;
        }
        declaredField.setAccessible(true);
        try {
            declaredField.set(this.dynamicBean, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void putAll(Object object) throws IllegalAccessException, NoSuchFieldException {
        Class<?> clazz = object.getClass();
        Field[] declaredFields = clazz.getDeclaredFields();
        HashMap<String, Object> fieldValuesMap = new HashMap<String, Object>(16);
        HashMap fieldTypeMap = new HashMap(16);
        for (Field field : declaredFields) {
            field.setAccessible(true);
            Object fieldValue = field.get(object);
            fieldValuesMap.put(field.getName(), fieldValue);
            fieldTypeMap.put(field.getName(), field.getType());
        }
        fieldTypeMap.putAll(this.getFields());
        fieldValuesMap.putAll(this.getValues());
        this.dynamicBean = this.generateBean(fieldTypeMap);
        this.clazz = this.dynamicBean.getClass();
        for (String key : fieldValuesMap.keySet()) {
            Object value = fieldValuesMap.get(key);
            this.put(key, value);
        }
    }

    public Map<String, Class<?>> getFields() {
        HashMap attrMap = new HashMap(16);
        if (this.clazz != null) {
            Iterator<String> iterator = this.getValues().keySet().iterator();
            while (iterator.hasNext()) {
                attrMap.put(iterator.next(), Object.class);
            }
        }
        return attrMap;
    }

    public Map<String, Class<?>> getFields(Object object) {
        Class<?> clazz = object.getClass();
        HashMap attrMap = new HashMap(16);
        if (clazz != null) {
            Iterator<String> iterator = this.getValues(object).keySet().iterator();
            while (iterator.hasNext()) {
                attrMap.put(iterator.next(), Object.class);
            }
        }
        return attrMap;
    }

    public JsonNode get(String property) {
        JsonNode jsonNode = OBJECT_MAPPER.valueToTree(this.dynamicBean);
        return jsonNode.get(property);
    }

    public <E> E getToObject(String property) throws NoSuchFieldException, IllegalAccessException {
        Field declaredField = this.clazz.getDeclaredField("$cglib_prop_" + property);
        declaredField.setAccessible(true);
        Class<?> type = declaredField.getType();
        return (E)declaredField.get(this.dynamicBean);
    }

    public Object getEntity() {
        return this.dynamicBean;
    }

    private Object generateBean(Map dynAttrMap) {
        BeanGenerator generator = new BeanGenerator();
        if (dynAttrMap != null) {
            Iterator iterator = dynAttrMap.keySet().iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                generator.addProperty(key, (Class)dynAttrMap.get(key));
            }
        }
        return generator.create();
    }

    public static JsonNode getResponseData(Map<String, Object> response) {
        return DynamicObject.parseMap(response).get("result").get("data");
    }

    public static <T> T convertDataToJavaBean(JsonNode jsonNode, Class<T> tClass) {
        try {
            String jsonString = OBJECT_MAPPER.writeValueAsString((Object)jsonNode);
            JSONObject jsonObject = JSON.parseObject((String)jsonString);
            return (T)JSON.toJavaObject((JSON)jsonObject, tClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> convertDataToJavaBeanList(JsonNode jsonNode, Class<T> tClass) {
        ArrayList<T> list = new ArrayList<T>();
        for (JsonNode node : jsonNode) {
            T t = DynamicObject.convertDataToJavaBean(node, tClass);
            list.add(t);
        }
        return list;
    }

    public Object getDynamicBean() {
        return this.dynamicBean;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setDynamicBean(Object dynamicBean) {
        this.dynamicBean = dynamicBean;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicObject)) {
            return false;
        }
        DynamicObject other = (DynamicObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$dynamicBean = this.getDynamicBean();
        Object other$dynamicBean = other.getDynamicBean();
        if (this$dynamicBean == null ? other$dynamicBean != null : !this$dynamicBean.equals(other$dynamicBean)) {
            return false;
        }
        Class this$clazz = this.getClazz();
        Class other$clazz = other.getClazz();
        return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $dynamicBean = this.getDynamicBean();
        result = result * 59 + ($dynamicBean == null ? 43 : $dynamicBean.hashCode());
        Class $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        return result;
    }

    public String toString() {
        return "DynamicObject(dynamicBean=" + this.getDynamicBean() + ", clazz=" + this.getClazz() + ")";
    }

    public DynamicObject() {
    }
}

