/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.service.impl;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.Db;
import cn.hutool.db.Entity;
import com.zaxxer.hikari.HikariDataSource;
import com.zx.utils.constant.Constants;
import com.zx.utils.controller.vo.GenerateConfigVO;
import com.zx.utils.controller.vo.PageVO;
import com.zx.utils.controller.vo.TableRequestVO;
import com.zx.utils.service.GenerateCodeService;
import com.zx.utils.util.CodeGenerateUtil;
import com.zx.utils.util.DataBaseUtil;
import com.zx.utils.util.DynamicObject;
import com.zx.utils.util.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import org.springframework.stereotype.Service;

@Service
public class GenerateCodeServiceImpl
implements GenerateCodeService {
    public static final String COUNT_SQL_TEMPLATE = "select count(1) from (%s)tmp";
    public static final String PAGE_SQL_TEMPLATE = "limit ? offset ? ";

    @Override
    public PageVO<Entity> listTables(TableRequestVO request) {
        DynamicObject dynamicVO = DynamicObject.parseMap(this.queryTable(request));
        List tables = (List)dynamicVO.getToObject("tables");
        BigDecimal count = (BigDecimal)dynamicVO.getToObject("tablesCount");
        PageVO<Entity> pageResult = new PageVO<Entity>(count.longValue(), request.getCurrentPage() - 1, request.getPageSize(), tables);
        return pageResult;
    }

    @Override
    public byte[] generatorCode(GenerateConfigVO generateConfigVO) throws SQLException {
        for (Map.Entry<String, String> entry : Constants.GENERATE_FFILE_MAP.entrySet()) {
            File file = CodeGenerateUtil.getResourcesFile("template/" + entry.getKey());
            if (file.exists()) continue;
            FileUtil.createFiles(file.getPath());
            FileUtil.write(file, entry.getValue(), "UTF-8");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(outputStream);
        List tables = null;
        try {
            tables = (List)DynamicObject.parseMap(this.queryTable(generateConfigVO.getRequest())).getToObject("tables");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<Entity> columns = this.queryColumns(generateConfigVO.getRequest());
        new CodeGenerateUtil().generatorCode(generateConfigVO, (Entity)tables.get(0), columns, zip);
        IoUtil.close((Closeable)zip);
        for (Map.Entry<String, String> entry : Constants.GENERATE_FFILE_MAP.entrySet()) {
            File file = CodeGenerateUtil.getResourcesFile("template/" + entry.getKey());
            FileUtil.deleteFile(file);
        }
        return outputStream.toByteArray();
    }

    public Map<String, Object> queryTable(TableRequestVO request) throws SQLException {
        String dataBaseType;
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> countParams = new ArrayList<String>();
        String paramSql = "";
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        String schemaName = request.getUrl().split("/")[1].split("\\?")[0];
        HikariDataSource dataSource = DataBaseUtil.createDataSource(request);
        Db db = new Db((DataSource)dataSource);
        Integer currentPage = request.getCurrentPage();
        Integer pageSize = request.getPageSize();
        if (StrUtil.isNotBlank((CharSequence)request.getTablename())) {
            paramSql = "and tableName='" + request.getTablename() + "'";
        }
        String queryTableSql = null;
        switch (dataBaseType = request.getPrepend().split(":")[1]) {
            case "mysql": {
                queryTableSql = "select * from (select table_name tableName, engine, table_comment tableComment, create_time createTime from information_schema.tables where table_schema = ?)as A where 1=1 ";
                params.add(schemaName);
                countParams.add(schemaName);
                break;
            }
            case "postgresql": {
                queryTableSql = "select * from (SELECT relname tableName, cast( obj_description ( relfilenode, 'pg_class' ) AS VARCHAR ) AS tableComment FROM pg_class c  WHERE relkind = 'r' AND relname NOT LIKE 'pg_%' AND relname NOT LIKE 'sql_%' )as A where 1=1 ";
                break;
            }
        }
        String sql = queryTableSql + paramSql;
        String countSql = String.format(COUNT_SQL_TEMPLATE, sql);
        if (currentPage != null && pageSize != null) {
            params.add(pageSize);
            params.add((currentPage - 1) * pageSize);
            sql = sql + PAGE_SQL_TEMPLATE;
        }
        List query = db.query(sql, params.toArray());
        BigDecimal count = (BigDecimal)db.queryNumber(countSql, countParams.toArray());
        result.put("tables", query);
        result.put("tablesCount", count);
        dataSource.close();
        return result;
    }

    public List<Entity> queryColumns(TableRequestVO request) throws SQLException {
        HikariDataSource dataSource = DataBaseUtil.createDataSource(request);
        Db db = new Db((DataSource)dataSource);
        String schemaName = request.getUrl().split("/")[1].split("\\?")[0];
        String tableName = request.getTablename();
        ArrayList<String> params = new ArrayList<String>();
        String dataBaseType = request.getPrepend().split(":")[1];
        String queryColumnSql = null;
        params.add(tableName);
        switch (dataBaseType) {
            case "mysql": {
                queryColumnSql = "select\n\tcolumn_name columnName,\n\tdata_type datatype,\n\tcolumn_comment columnComment,\n\tcolumn_key columnKey,\n\tcase\n\t\twhen is_nullable = 'NO' then 'false'\n\t\telse 'true'\n\tend as nullAbled,\n\textra\nfrom\n\tinformation_schema.columns\nwhere\n\ttable_name = ?\n\tand table_schema = ?";
                params.add(schemaName);
                break;
            }
            case "postgresql": {
                queryColumnSql = "select\n\ta.attname as columnName,\n\tformat_type(a.atttypid, a.atttypmod) as datatype,\n\tcol_description(a.attrelid, a.attnum) as columnComment,\n\tcase\n\t\twhen a.attnotnull then 'false'\n\t\telse 'true'\n\tend as nullAbled,\n\tcase\n\t\twhen a.attname=f.attname then 'PRI'\n\t\telse ''\n\tend as columnKey\nfrom\n\tpg_class as c,\n\tpg_attribute as a\nleft join (\n\tselect\n\t\tpg_attribute.attname\n\tfrom\n\t\tpg_index,\n\t\tpg_class,\n\t\tpg_attribute\n\twhere\n\t\tpg_class.oid = ? :: regclass\n\t\tand pg_index.indrelid = pg_class.oid\n\t\tand pg_attribute.attrelid = pg_class.oid\n\t\tand pg_attribute.attnum = any (pg_index.indkey)\n) f on\n\t1=1\nwhere\n\tc.relname = ?\n\tand a.attrelid = c.oid\n\tand a.attnum>0";
                params.add(tableName);
                break;
            }
        }
        List query = db.query(queryColumnSql, params.toArray());
        dataSource.close();
        return query;
    }
}

