/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import com.zx.utils.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipUtil {
    public static void deCompress(File file, String dest) throws IOException {
        ZipFile zf = new ZipFile(dest);
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dest));){
            String dir = "";
            if (file.isDirectory()) {
                dir = file.getName();
            }
            ZipUtil.zipFile(file, zos, dir);
        }
    }

    public static void zipFile(File inFile, ZipOutputStream zos, String dir) throws IOException {
        if (inFile.isDirectory()) {
            File[] files = inFile.listFiles();
            if (files == null || files.length == 0) {
                String entryName = dir + "/";
                zos.putNextEntry(new ZipEntry(entryName));
                return;
            }
            for (File file : files) {
                String entryName = dir + "/" + file.getName();
                if (file.isDirectory()) {
                    ZipUtil.zipFile(file, zos, entryName);
                    continue;
                }
                ZipEntry entry = new ZipEntry(entryName);
                zos.putNextEntry(entry);
                try (FileInputStream is = new FileInputStream(file);){
                    int len = 0;
                    while ((len = ((InputStream)is).read()) != -1) {
                        zos.write(len);
                    }
                }
            }
        } else {
            String entryName = dir + "/" + inFile.getName();
            ZipEntry entry = new ZipEntry(entryName);
            zos.putNextEntry(entry);
            try (FileInputStream is = new FileInputStream(inFile);){
                int len = 0;
                while ((len = ((InputStream)is).read()) != -1) {
                    zos.write(len);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unCompress(File source, String path) throws IOException {
        ZipEntry zipEntry = null;
        FileUtil.createPaths(path);
        try (ZipFile zipFile = new ZipFile(source);){
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(source));
            Throwable throwable = null;
            block40: while (true) {
                try {
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        File temp;
                        String fileName = zipEntry.getName();
                        String filePath = path + "/" + fileName;
                        if (zipEntry.isDirectory()) {
                            temp = new File(filePath);
                            if (temp.exists()) continue;
                            temp.mkdirs();
                            continue;
                        }
                        temp = new File(filePath);
                        if (!temp.getParentFile().exists()) {
                            temp.getParentFile().mkdirs();
                        }
                        try {
                            FileOutputStream os = new FileOutputStream(temp);
                            Throwable throwable2 = null;
                            try {
                                InputStream is = zipFile.getInputStream(zipEntry);
                                Throwable throwable3 = null;
                                try {
                                    int len = 0;
                                    while (true) {
                                        if ((len = is.read()) == -1) continue block40;
                                        ((OutputStream)os).write(len);
                                    }
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (is == null) continue block40;
                                    if (throwable3 != null) {
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable3.addSuppressed(throwable5);
                                        }
                                        continue block40;
                                    }
                                    is.close();
                                    continue block40;
                                }
                            }
                            catch (Throwable throwable6) {
                                throwable2 = throwable6;
                                throw throwable6;
                            }
                            finally {
                                if (os == null) continue block40;
                                if (throwable2 != null) {
                                    try {
                                        ((OutputStream)os).close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable2.addSuppressed(throwable7);
                                    }
                                    continue block40;
                                }
                                ((OutputStream)os).close();
                                continue block40;
                            }
                        }
                        catch (IOException e) {
                            throw e;
                            return;
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
            }
            finally {
                if (zipInputStream != null) {
                    if (throwable != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        zipInputStream.close();
                    }
                }
            }
        }
    }
}

