/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodExecuteUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodExecuteUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <Q, B> B logAround(Q request, LogMethodFunction<Q, B> function) {
        SerializedLambda serializedLambda = null;
        try {
            serializedLambda = function.getSerializedLambda();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String className = serializedLambda.getImplClass();
        String[] packageSplit = className.split("/");
        className = packageSplit[packageSplit.length - 1];
        String methodName = serializedLambda.getImplMethodName();
        methodName = className + "." + methodName + " ";
        log.info(methodName + "execute before, requestBody: {}", (Object)OBJECT_MAPPER.valueToTree(request));
        B responseBody = null;
        long startTime = System.currentTimeMillis();
        try {
            responseBody = function.execute(request);
        }
        catch (Throwable e) {
            log.error(methodName + "execute error, exception: {}", (Object)OBJECT_MAPPER.valueToTree((Object)e));
        }
        finally {
            log.info(methodName + "execute after, responseBody: {}", (Object)OBJECT_MAPPER.valueToTree(responseBody));
            log.info(methodName + "execute time: {}", (Object)(System.currentTimeMillis() - startTime + " millisecond"));
        }
        return responseBody;
    }

    @FunctionalInterface
    public static interface LogMethodFunction<Q, B>
    extends Serializable {
        public B execute(Q var1);

        default public SerializedLambda getSerializedLambda() throws Exception {
            Method write = this.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            write.setAccessible(true);
            return (SerializedLambda)write.invoke((Object)this, new Object[0]);
        }
    }
}

