/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static PoolingHttpClientConnectionManager cm = null;
    private static RequestConfig requestConfig = null;

    public static CloseableHttpClient getHttpClient() {
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        return httpClient;
    }

    public static void closeResponse(CloseableHttpResponse closeableHttpResponse) throws IOException {
        EntityUtils.consume((HttpEntity)closeableHttpResponse.getEntity());
        closeableHttpResponse.close();
    }

    public static String get(JSONObject headers, String url, JSONObject params) {
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        CloseableHttpResponse closeableHttpResponse = null;
        HttpGet httpGet = null;
        ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
        if (params != null) {
            for (String paramName : params.keySet()) {
                paramList.add(new BasicNameValuePair(paramName, params.get((Object)paramName).toString()));
            }
        }
        try {
            httpGet = url.contains("?") ? new HttpGet(url + "&" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(paramList, Consts.UTF_8))) : new HttpGet(url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(paramList, Consts.UTF_8)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (headers != null) {
            Iterator iterator = headers.keySet().iterator();
            while (iterator.hasNext()) {
                String headerName = iterator.next().toString();
                httpGet.addHeader(headerName, headers.get((Object)headerName).toString());
            }
        }
        httpGet.setConfig(requestConfig);
        httpGet.addHeader("Content-Type", "application/json");
        httpGet.addHeader("lastOperaTime", String.valueOf(System.currentTimeMillis()));
        try {
            closeableHttpResponse = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = closeableHttpResponse.getEntity();
            String response = EntityUtils.toString((HttpEntity)entity);
            HttpClientUtil.closeResponse(closeableHttpResponse);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String post(JSONObject headers, String url, JSONObject params) {
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        CloseableHttpResponse closeableHttpResponse = null;
        HttpPost httpPost = new HttpPost(url);
        if (headers != null) {
            Iterator iterator = headers.keySet().iterator();
            while (iterator.hasNext()) {
                String headerName = iterator.next().toString();
                httpPost.addHeader(headerName, headers.get((Object)headerName).toString());
            }
        }
        httpPost.setConfig(requestConfig);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.addHeader("lastOperaTime", String.valueOf(System.currentTimeMillis()));
        if (params != null) {
            StringEntity stringEntity = new StringEntity(params.toJSONString(), "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        try {
            closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = closeableHttpResponse.getEntity();
            String response = EntityUtils.toString((HttpEntity)entity);
            HttpClientUtil.closeResponse(closeableHttpResponse);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String delete(JSONObject headers, String url, JSONObject params) {
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        CloseableHttpResponse closeableHttpResponse = null;
        HttpDeleteWithBody httpDelete = new HttpDeleteWithBody(url);
        if (headers != null) {
            Iterator iterator = headers.keySet().iterator();
            while (iterator.hasNext()) {
                String headerName = iterator.next().toString();
                httpDelete.addHeader(headerName, headers.get((Object)headerName).toString());
            }
        }
        httpDelete.setConfig(requestConfig);
        httpDelete.addHeader("Content-Type", "application/json");
        httpDelete.addHeader("lastOperaTime", String.valueOf(System.currentTimeMillis()));
        if (params != null) {
            StringEntity stringEntity = new StringEntity(params.toJSONString(), "UTF-8");
            httpDelete.setEntity((HttpEntity)stringEntity);
        }
        try {
            closeableHttpResponse = httpClient.execute((HttpUriRequest)httpDelete);
            HttpEntity entity = closeableHttpResponse.getEntity();
            String response = EntityUtils.toString((HttpEntity)entity);
            HttpClientUtil.closeResponse(closeableHttpResponse);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String put(JSONObject headers, String url, JSONObject params) {
        CloseableHttpClient httpClient = HttpClientUtil.getHttpClient();
        CloseableHttpResponse closeableHttpResponse = null;
        HttpPut httpPut = new HttpPut(url);
        if (headers != null) {
            Iterator iterator = headers.keySet().iterator();
            while (iterator.hasNext()) {
                String headerName = iterator.next().toString();
                httpPut.addHeader(headerName, headers.get((Object)headerName).toString());
            }
        }
        httpPut.setConfig(requestConfig);
        httpPut.addHeader("Content-Type", "application/json");
        httpPut.addHeader("lastOperaTime", String.valueOf(System.currentTimeMillis()));
        if (params != null) {
            StringEntity stringEntity = new StringEntity(params.toJSONString(), "UTF-8");
            httpPut.setEntity((HttpEntity)stringEntity);
        }
        try {
            closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPut);
            HttpEntity entity = closeableHttpResponse.getEntity();
            String response = EntityUtils.toString((HttpEntity)entity);
            HttpClientUtil.closeResponse(closeableHttpResponse);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        SSLConnectionSocketFactory sslsf = null;
        try {
            sslsf = new SSLConnectionSocketFactory(SSLContext.getDefault());
        }
        catch (NoSuchAlgorithmException e) {
            log.error("\u521b\u5efaSSL\u8fde\u63a5\u5931\u8d25");
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
        cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        cm.setMaxTotal(200);
        cm.setDefaultMaxPerRoute(300);
        requestConfig = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(20000).setExpectContinueEnabled(true).setConnectionRequestTimeout(10000).build();
    }

    public static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }

        public HttpDeleteWithBody(URI uri) {
            this.setURI(uri);
        }

        public HttpDeleteWithBody() {
        }
    }
}

