/*
 * Decompiled with CFR 0.152.
 */
package com.zx.utils.controller;

import com.zx.utils.annotation.ModelMapping;
import com.zx.utils.controller.PageVO;
import com.zx.utils.repository.BaseRepository;
import com.zx.utils.util.BaseConverter;
import com.zx.utils.util.ReflectUtil;
import com.zx.utils.util.SpringManager;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseControllerModel<S, E>
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(BaseControllerModel.class);
    public BaseRepository<E, Long> baseRepository;
    private Type[] actualTypeArguments;
    private final BaseConverter baseConverter = new BaseConverter();

    @RequestMapping(path={""}, method={RequestMethod.POST})
    @ModelMapping
    @ApiOperation(value="\u65b0\u589e", notes="")
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public synchronized void add(@RequestBody S entityVO) {
        Object entity = this.baseConverter.convertSingleObject(entityVO, (Class)this.actualTypeArguments[1]);
        try {
            ReflectUtil.setValue(entity, "valid", 1);
        }
        catch (Exception e) {
            logger.warn("\u6ca1\u6709\u627e\u5230\u5c5e\u6027\uff1avalid");
        }
        this.baseRepository.save(entity);
    }

    @RequestMapping(path={""}, method={RequestMethod.PUT})
    @ModelMapping
    @ApiOperation(value="\u66f4\u65b0", notes="\u5fc5\u987b\u4f20\u6570\u636e\u5e93id\u503c")
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void update(@RequestBody S entityVO) {
        Object entity = this.baseConverter.convertSingleObject(entityVO, (Class)this.actualTypeArguments[1]);
        try {
            ReflectUtil.setValue(entity, "valid", 1);
        }
        catch (Exception e) {
            logger.warn("\u6ca1\u6709\u627e\u5230\u5c5e\u6027\uff1avalid");
        }
        this.baseRepository.save(entity);
    }

    @RequestMapping(path={"/{ids}"}, method={RequestMethod.DELETE})
    @ModelMapping
    @ApiOperation(value="\u4fe1\u606f\u5220\u9664", notes="\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00")
    @Transactional(isolation=Isolation.READ_COMMITTED, rollbackFor={Exception.class})
    public void deleteValid(@PathVariable String ids) {
        this.baseRepository.deleteValid(ids);
    }

    @RequestMapping(path={"/{attr}/{condition}"}, method={RequestMethod.GET})
    @ModelMapping
    @ApiOperation(value="\u5355\u6761\u4ef6\u67e5\u8be2", notes="\u5bf9\u8c61\u7684\u6240\u6709\u5c5e\u6027\u53ef\u4f5c\u4e3a\u6761\u4ef6\u8fdb\u884c\u67e5\u8be2\uff0c\u8fd4\u56de\u4e00\u4e2a\u8bbe\u5907\u5bf9\u8c61\u7684\u5b9e\u4f53\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="attr", value="\u5bf9\u8c61\u5c5e\u6027\u4f8b\u5982\uff1aid", required=true), @ApiImplicitParam(name="condition", value="\u6761\u4ef6\u4f8b\u5982\uff1a1", required=true)})
    public S findOneByAttr(@PathVariable String attr, @PathVariable String condition) {
        return (S)this.baseConverter.convertSingleObject(this.baseRepository.findOneByAttr(attr, condition), (Class)this.actualTypeArguments[0]);
    }

    @RequestMapping(path={"/list/{attr}/{condition}"}, method={RequestMethod.GET})
    @ModelMapping
    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\uff0c\u7cbe\u51c6\u67e5\u8be2\uff0c\u53ef\u4f5c\u4e3a\u6761\u4ef6\u7684\u4e3a\u5bf9\u8c61\u7684\u6240\u6709\u5c5e\u6027\uff0c\u8fd4\u56de\u4e00\u4e2a\u5217\u8868", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="attr", value="\u5bf9\u8c61\u5c5e\u6027\u4f8b\u5982\uff1aid", required=true), @ApiImplicitParam(name="condition", value="\u6761\u4ef6\u4f8b\u5982\uff1a1,2,3", required=true)})
    public List<S> findByAttrs(@PathVariable String attr, @PathVariable String condition) {
        return this.baseConverter.convertMultiObjectToList(this.baseRepository.findByAttr(attr, condition), (Class)this.actualTypeArguments[0]);
    }

    @RequestMapping(path={"/findAll"}, method={RequestMethod.GET})
    @ModelMapping
    @ApiOperation(value="\u591a\u6761\u4ef6\u7ec4\u5408\u67e5\u8be2\u6240\u6709", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="objConditions", value="\u5bf9\u8c61\u6761\u4ef6\uff0c\u5b57\u7b26\u4e32\u7c7b\u578b\u5c5e\u6027\u9ed8\u8ba4\u4f7f\u7528\u6a21\u7cca\u67e5\u8be2\u4f8b\uff1a?id=1,2,3&name=5201"), @ApiImplicitParam(name="sorter", value="\u6392\u5e8f\u6761\u4ef6\uff1asorter={\"id\":\"descend\"}\uff0cascend\u5347\u5e8f\uff0cdescend\u964d\u5e8f"), @ApiImplicitParam(name="excludeLikeAttr", value="\u662f\u5b57\u7b26\u4e32\u7c7b\u578b\u5c5e\u6027\u4f46\u4e0d\u4f7f\u7528\u6a21\u7cca\u67e5\u8be2\u7684\u5b57\u6bb5\uff0c\u9017\u53f7\u9694\u5f00")})
    public List<S> findAllByConditions(@RequestParam(required=false) Map<String, String> objConditions, @RequestParam(name="sorter", required=false) String sorter, @RequestParam(name="excludeLikeAttr", defaultValue="", required=false) String excludeLikeAttr) {
        List<String> excludeAttrs = Arrays.asList(excludeLikeAttr.split(","));
        List<E> byConditions = this.baseRepository.findByConditions(objConditions, excludeAttrs, sorter);
        return this.baseConverter.convertMultiObjectToList(byConditions, (Class)this.actualTypeArguments[0]);
    }

    @RequestMapping(path={"/findByPage"}, method={RequestMethod.GET})
    @ModelMapping
    @ApiOperation(value="\u591a\u6761\u4ef6\u7ec4\u5408\u5206\u9875\u67e5\u8be2", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="objConditions", value="\u5bf9\u8c61\u6761\u4ef6\uff0c\u5b57\u7b26\u4e32\u7c7b\u578b\u5c5e\u6027\u9ed8\u8ba4\u4f7f\u7528\u6a21\u7cca\u67e5\u8be2\u4f8b\uff1a?id=1,2,3&name=5201"), @ApiImplicitParam(name="sorter", value="\u6392\u5e8f\u6761\u4ef6\uff1asorter={\"id\":\"descend\"}\uff0cascend\u5347\u5e8f\uff0cdescend\u964d\u5e8f"), @ApiImplicitParam(name="excludeLikeAttr", value="\u662f\u5b57\u7b26\u4e32\u7c7b\u578b\u5c5e\u6027\u4f46\u4e0d\u4f7f\u7528\u6a21\u7cca\u67e5\u8be2\u7684\u5b57\u6bb5\uff0c\u9017\u53f7\u9694\u5f00"), @ApiImplicitParam(name="current", value="\u5f53\u524d\u9875\u9ed8\u8ba4\u7b2c 1 \u9875"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6570\u636e\u6761\u6570\u9ed8\u8ba4 20 \u6761")})
    public PageVO<S> findByPage(@RequestParam(required=false) Map<String, String> objConditions, @RequestParam(name="sorter", required=false) String sorter, @RequestParam(name="excludeLikeAttr", defaultValue="", required=false) String excludeLikeAttr, @RequestParam(name="current", required=false, defaultValue="1") Integer current, @RequestParam(name="pageSize", required=false, defaultValue="20") Integer pageSize) {
        List<String> excludeAttrs = Arrays.asList(excludeLikeAttr.split(","));
        Page<E> byPage = this.baseRepository.findByPage(objConditions, current, pageSize, excludeAttrs, sorter);
        return this.baseConverter.convertMultiObjectToMap(byPage, (Class)this.actualTypeArguments[0]);
    }

    public void run(ApplicationArguments args) {
        Class<?> aClass = this.getClass();
        Type genericSuperclass = aClass.getGenericSuperclass();
        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        this.actualTypeArguments = actualTypeArguments;
        List<String> strings = Arrays.asList(aClass.getName().split("\\."));
        String controllerName = strings.get(strings.size() - 1);
        String serviceApi = Character.toLowerCase(controllerName.charAt(0)) + controllerName.split("Controller")[0].substring(1);
        this.baseRepository = (BaseRepository)SpringManager.getBean(serviceApi + "Repository");
    }
}

