/*
 * Decompiled with CFR 0.152.
 */
package com.zx.util.controller;

import com.zx.util.annotation.ModelMapping;
import com.zx.util.service.MyRepository;
import com.zx.util.util.MyBaseConverter;
import com.zx.util.util.SpringManager;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

public class MyControllerModel<S>
implements ApplicationRunner {
    public MyRepository myRepository;
    Type[] actualTypeArguments;
    MyBaseConverter myBaseConverter = new MyBaseConverter();

    @RequestMapping(path={""}, method={RequestMethod.POST})
    @ModelMapping
    public void save(@RequestBody S entityVO) {
        this.myRepository.save(entityVO);
    }

    @RequestMapping(path={""}, method={RequestMethod.PUT})
    @ModelMapping
    public void update(@RequestBody S entityVO) {
        this.myRepository.save(entityVO);
    }

    @RequestMapping(path={"/{ids}"}, method={RequestMethod.DELETE})
    @ModelMapping
    public void deleteValid(@PathVariable String ids) {
        this.myRepository.deleteValid(ids);
    }

    @RequestMapping(path={"/{attr}/{condition}"}, method={RequestMethod.GET})
    @ModelMapping
    public S findByAttr(@PathVariable String attr, @PathVariable String condition) {
        return (S)this.myRepository.findOneByAttr(attr, condition);
    }

    @RequestMapping(path={"/findAll"}, method={RequestMethod.GET})
    @ModelMapping
    public List findAllByConditions(@RequestParam Map tableMap) {
        return this.myRepository.findByConditions(tableMap);
    }

    @RequestMapping(path={"/findByPage"}, method={RequestMethod.GET})
    @ModelMapping
    public Map<String, Object> findByPage(@RequestParam Map tableMap) {
        Page byPage = this.myRepository.findByPage(tableMap);
        return this.myBaseConverter.convertMultiObjectToMap(byPage, (Class)this.actualTypeArguments[0]);
    }

    public void run(ApplicationArguments args) throws Exception {
        Class<?> aClass = this.getClass();
        Class<?> superclass = this.getClass().getSuperclass();
        List<String> strings = Arrays.asList(aClass.getName().split("\\."));
        String controllerName = strings.get(strings.size() - 1);
        String serviceApi = Character.toLowerCase(controllerName.charAt(0)) + controllerName.split("Controller")[0].substring(1);
        this.myRepository = (MyRepository)SpringManager.getBean(serviceApi + "Repository");
    }
}

