/*
 * Decompiled with CFR 0.152.
 */
package cn.sunjinxin.savior.sequence.service;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisIdWorker {
    private static final long BEGIN_TIMESTAMP = 1704067200L;
    private static final int COUNT_BITS = 32;
    private final StringRedisTemplate stringRedisTemplate;

    public RedisIdWorker(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public long nextId(String keyPrefix) {
        LocalDateTime now = LocalDateTime.now();
        long nowSecond = now.toEpochSecond(ZoneOffset.UTC);
        long timestamp = nowSecond - 1704067200L;
        String date = now.format(DateTimeFormatter.ofPattern("yyyy:MM:dd"));
        Long count = this.stringRedisTemplate.opsForValue().increment((Object)("icr:" + keyPrefix + ":" + date));
        return timestamp << 32 | (count == null ? 0L : count);
    }

    public static void main(String[] args) {
        LocalDateTime startLocalTime = LocalDateTime.of(2024, 1, 1, 0, 0, 0);
        long startTime = startLocalTime.toEpochSecond(ZoneOffset.UTC);
        System.out.println(startTime);
        LocalDateTime now = LocalDateTime.now();
        String date = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        System.out.println(date);
    }
}

