/*
 * Decompiled with CFR 0.152.
 */
package cn.sunjinxin.savior.ext.container;

import cn.hutool.core.lang.Assert;
import cn.sunjinxin.savior.ext.anno.Ability;
import cn.sunjinxin.savior.ext.anno.ExtensionPoint;
import cn.sunjinxin.savior.ext.container.ExtParam;
import cn.sunjinxin.savior.ext.container.IExt;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ExtContainer
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(ExtContainer.class);
    private static final Map<String, Map<Class<? extends IExt>, Map<String, List<IExt>>>> EXTENSION_MAP = Maps.newHashMap();

    public static List<IExt> getBeans(ExtParam request, Class<IExt> clazz) {
        return EXTENSION_MAP.get(String.format("%s_%s", request.getIndustry(), request.getBusiness())).get(clazz).get(String.format("%s_%s", request.getBizCode(), request.getScenario()));
    }

    public Object postProcessAfterInitialization(Object bean, @Nonnull String beanName) throws BeansException {
        ExtensionPoint[] annotations = (ExtensionPoint[])bean.getClass().getAnnotationsByType(ExtensionPoint.class);
        if (annotations.length == 0) {
            return super.postProcessAfterInitialization(bean, beanName);
        }
        ExtensionPoint extensionPoint = annotations[0];
        Class<? extends IExt> superclass = this.checkAbs(bean);
        Ability ability = superclass.getAnnotation(Ability.class);
        Assert.isTrue((boolean)ObjectUtils.isNotEmpty((Object)ability), () -> new RuntimeException("error"));
        EXTENSION_MAP.computeIfAbsent(String.format("%s_%s", ability.industry(), ability.business()), v -> Maps.newHashMap()).computeIfAbsent(superclass, v -> Maps.newHashMap()).computeIfAbsent(String.format("%s_%s", extensionPoint.bizCode(), extensionPoint.scenario()), v -> Lists.newArrayList()).add((IExt)bean);
        return super.postProcessAfterInitialization(bean, beanName);
    }

    private Class<? extends IExt> checkAbs(Object bean) {
        Class<?> superclass = bean.getClass().getSuperclass();
        if (Optional.ofNullable(superclass).filter(abs -> Arrays.stream(abs.getInterfaces()).anyMatch(r -> r == IExt.class)).isPresent()) {
            ExtContainer.beanSpecs(bean.getClass());
        }
        return superclass;
    }

    private static void beanSpecs(Class<?> aClass) {
        throw new RuntimeException("According to the usage guidelines of savior-ext, your encoding has encountered an error as follows: bean usage exception " + aClass);
    }
}

