/*
 * Decompiled with CFR 0.152.
 */
package cn.sunjinxin.savior.event.handler.async.impl;

import cn.sunjinxin.savior.core.helper.SpringHelper;
import cn.sunjinxin.savior.event.configuration.EventProperties;
import cn.sunjinxin.savior.event.constant.EventStrategy;
import cn.sunjinxin.savior.event.context.InnerEventContext;
import cn.sunjinxin.savior.event.control.Eventer;
import cn.sunjinxin.savior.event.handler.async.AsyncEventHandler;
import com.google.common.collect.Lists;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.dsl.Disruptor;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class DisruptorAsyncEventHandler
extends AsyncEventHandler {
    private static final int BUFFER_SIZE = 1024;
    static volatile AtomicReference<Disruptor<InnerEventContext>> INSTANCE = new AtomicReference();
    static volatile AtomicBoolean startMark = new AtomicBoolean(false);

    @Override
    public List<EventStrategy> strategy() {
        return Lists.newArrayList((Object[])new EventStrategy[]{EventStrategy.DISRUPTOR});
    }

    @Override
    public void register(Object eventClass) {
        Lists.newArrayList((Object[])new Object[]{eventClass}).forEach(r -> DisruptorAsyncEventHandler.of().handleEventsWith(new EventHandler[]{(EventHandler)r}));
    }

    @Override
    public void post(Object eventContext) {
        Optional.of(startMark.get()).filter(BooleanUtils::isFalse).ifPresent(r -> {
            DisruptorAsyncEventHandler.of().start();
            startMark.set(true);
        });
        Lists.newArrayList((Object[])new Object[]{eventContext}).forEach(r -> DisruptorAsyncEventHandler.of().getRingBuffer().publishEvent((event, l) -> {
            event.setEventContext(((InnerEventContext)r).getEventContext());
            event.setEventer(Eventer.ASYNC);
        }));
    }

    @Override
    public void unregister(Object eventClass) {
    }

    private static Disruptor<InnerEventContext> of() {
        return Optional.ofNullable(INSTANCE.get()).orElseGet(() -> INSTANCE.updateAndGet(r -> new Disruptor(InnerEventContext::new, 1024, (ThreadFactory)new CustomizableThreadFactory(((EventProperties)SpringHelper.getBean(EventProperties.class)).getAsyncThreadPool().getThreadNamePrefix()))));
    }
}

