/*
 * Decompiled with CFR 0.152.
 */
package cn.sunjinxin.savior.event.convert;

import cn.hutool.core.lang.Assert;
import cn.sunjinxin.savior.core.helper.SpringHelper;
import cn.sunjinxin.savior.event.EventRun;
import cn.sunjinxin.savior.event.configuration.EventProperties;
import cn.sunjinxin.savior.event.configuration.ThreadPoolProperties;
import cn.sunjinxin.savior.event.exception.EventException;
import cn.sunjinxin.savior.event.handler.EventHandler;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class EventCommon {
    public static ThreadPoolTaskExecutor buildThreadPoolTaskExecutor() {
        ThreadPoolProperties properties = ((EventProperties)SpringHelper.getBean(EventProperties.class)).getAsyncThreadPool();
        EventCommon.checkThreadPoolProperties(properties);
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(properties.getCorePoolSize().intValue());
        threadPoolTaskExecutor.setMaxPoolSize(properties.getMaxPoolSize().intValue());
        threadPoolTaskExecutor.setQueueCapacity(properties.getQueueCapacity().intValue());
        threadPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        threadPoolTaskExecutor.setThreadNamePrefix(properties.getThreadNamePrefix());
        threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        threadPoolTaskExecutor.setAwaitTerminationSeconds(5);
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    private static void checkThreadPoolProperties(ThreadPoolProperties properties) {
        Assert.isFalse((properties.getCorePoolSize() > properties.getMaxPoolSize() ? 1 : 0) != 0, () -> new EventException("savior-event`s ThreadPoolProperties has exception:[CorePoolSize > MaxPoolSize]"));
    }

    public static List<EventHandler> buildEventHandlers() {
        return Optional.of(new Reflections(EventRun.class.getPackage().getName(), new Scanner[0])).map(r -> r.getSubTypesOf(EventHandler.class)).orElse(Sets.newHashSet()).stream().filter(r -> !r.isInterface()).filter(r -> !Modifier.isAbstract(r.getModifiers())).map(EventCommon::newInstance).collect(Collectors.toList());
    }

    private static EventHandler newInstance(Class<? extends EventHandler> r) {
        try {
            return r.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }
}

