/*
 * Decompiled with CFR 0.152.
 */
package cn.sunjinxin.savior.event.configuration;

import cn.sunjinxin.savior.event.configuration.EventProperties;
import cn.sunjinxin.savior.event.container.EventContainer;
import cn.sunjinxin.savior.event.convert.EventCommon;
import cn.sunjinxin.savior.event.handler.EventHandler;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync
public class EventAutoConfiguration {
    @Bean
    public EventProperties eventProperties() {
        return new EventProperties();
    }

    @Bean(value={"eventTaskExecutor"})
    public TaskExecutor taskExecutor1() {
        return EventCommon.buildThreadPoolTaskExecutor();
    }

    @Bean
    public List<EventHandler> eventHandlers() {
        return EventCommon.buildEventHandlers();
    }

    @Bean
    public EventContainer eventContainer(EventProperties eventProperties, List<EventHandler> eventHandlers) {
        return new EventContainer(eventHandlers, eventProperties);
    }

    private static EventHandler newInstance(Class<? extends EventHandler> r) {
        try {
            return r.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }
}

