/*
 * Decompiled with CFR 0.152.
 */
package cn.sunjinxin.savior.event.handler.async.impl;

import cn.sunjinxin.savior.core.helper.SpringHelper;
import cn.sunjinxin.savior.event.configuration.EventProperties;
import cn.sunjinxin.savior.event.configuration.ThreadPoolProperties;
import cn.sunjinxin.savior.event.constant.EventStrategy;
import cn.sunjinxin.savior.event.handler.async.AsyncEventHandler;
import com.google.common.collect.Lists;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DefaultAsyncEventHandler
extends AsyncEventHandler {
    static volatile AtomicReference<AsyncEventBus> INSTANCE = new AtomicReference();

    @Override
    public EventStrategy strategy() {
        return EventStrategy.DEFAULT;
    }

    @Override
    public void register(Object eventClass) {
        Lists.newArrayList((Object[])new Object[]{eventClass}).forEach(r -> DefaultAsyncEventHandler.of().register(r));
    }

    @Override
    public void post(Object eventContext) {
        Lists.newArrayList((Object[])new Object[]{eventContext}).forEach(r -> DefaultAsyncEventHandler.of().post(r));
    }

    @Override
    public void unregister(Object eventClass) {
        Lists.newArrayList((Object[])new Object[]{eventClass}).forEach(r -> DefaultAsyncEventHandler.of().unregister(r));
    }

    private static EventBus of() {
        return (EventBus)Optional.ofNullable(INSTANCE.get()).orElseGet(() -> INSTANCE.updateAndGet(r -> new AsyncEventBus((Executor)DefaultAsyncEventHandler.getExecutor())));
    }

    private static ThreadPoolTaskExecutor getExecutor() {
        ThreadPoolProperties pool = ((EventProperties)SpringHelper.getBean(EventProperties.class)).getAsyncThreadPool();
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(pool.getCorePoolSize().intValue());
        executor.setMaxPoolSize(pool.getMaxPoolSize().intValue());
        executor.setQueueCapacity(pool.getQueueCapacity().intValue());
        executor.setThreadNamePrefix(pool.getThreadNamePrefix());
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

