/*
 * Decompiled with CFR 0.152.
 */
package cn.sunjinxin.savior.event.configuration;

import cn.sunjinxin.savior.event.EventRun;
import cn.sunjinxin.savior.event.configuration.EventProperties;
import cn.sunjinxin.savior.event.container.EventContainer;
import cn.sunjinxin.savior.event.handler.EventHandler;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EventAutoConfiguration {
    @Bean
    public EventProperties eventProperties() {
        return new EventProperties();
    }

    @Bean
    public List<EventHandler> eventHandlers() {
        return Optional.of(new Reflections(EventRun.class.getPackage().getName(), new Scanner[0])).map(r -> r.getSubTypesOf(EventHandler.class)).orElse(Sets.newHashSet()).stream().filter(r -> !r.isInterface()).filter(r -> !Modifier.isAbstract(r.getModifiers())).map(EventAutoConfiguration::newInstance).collect(Collectors.toList());
    }

    @Bean
    public EventContainer eventContainer(EventProperties eventProperties, List<EventHandler> eventHandlers) {
        return new EventContainer(eventHandlers, eventProperties);
    }

    private static EventHandler newInstance(Class<? extends EventHandler> r) {
        try {
            return r.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }
}

