/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.validator.starter;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.TimedCache;
import cn.stylefeng.roses.kemel.blackwhite.BlackListService;
import cn.stylefeng.roses.kemel.blackwhite.WhiteListService;
import cn.stylefeng.roses.kemel.blackwhite.cache.BlackListMemoryCache;
import cn.stylefeng.roses.kemel.blackwhite.cache.WhiteListMemoryCache;
import cn.stylefeng.roses.kemel.captcha.CaptchaService;
import cn.stylefeng.roses.kemel.captcha.cache.CaptchaMemoryCache;
import cn.stylefeng.roses.kemel.count.DefaultCountValidator;
import cn.stylefeng.roses.kemel.count.cache.DefaultCountValidateCache;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.cache.api.constants.CacheConstants;
import cn.stylefeng.roses.kernel.validator.BlackListApi;
import cn.stylefeng.roses.kernel.validator.CaptchaApi;
import cn.stylefeng.roses.kernel.validator.CountValidatorApi;
import cn.stylefeng.roses.kernel.validator.WhiteListApi;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ValidatorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BlackListApi.class})
    public BlackListApi blackListApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        BlackListMemoryCache blackListMemoryCache = new BlackListMemoryCache(timedCache);
        return new BlackListService((CacheOperatorApi)blackListMemoryCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={CountValidatorApi.class})
    public CountValidatorApi countValidatorApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        DefaultCountValidateCache defaultCountValidateCache = new DefaultCountValidateCache(timedCache);
        return new DefaultCountValidator((CacheOperatorApi)defaultCountValidateCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={WhiteListApi.class})
    public WhiteListApi whiteListApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        WhiteListMemoryCache whiteListMemoryCache = new WhiteListMemoryCache(timedCache);
        return new WhiteListService((CacheOperatorApi)whiteListMemoryCache);
    }

    @Bean
    @ConditionalOnMissingBean(value={CaptchaApi.class})
    public CaptchaApi captchaApi() {
        TimedCache timedCache = CacheUtil.newTimedCache((long)CacheConstants.NONE_EXPIRED_TIME);
        CaptchaMemoryCache captchaMemoryCache = new CaptchaMemoryCache(timedCache);
        return new CaptchaService((CacheOperatorApi)captchaMemoryCache);
    }
}

