/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.validator.api.validators.unique.service;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.db.api.DbOperatorApi;
import cn.stylefeng.roses.kernel.db.api.context.DbOperatorContext;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.validator.api.exception.ParamValidateException;
import cn.stylefeng.roses.kernel.validator.api.exception.enums.ValidatorExceptionEnum;
import cn.stylefeng.roses.kernel.validator.api.pojo.UniqueValidateParam;

public class TableUniqueValueService {
    public static boolean getFiledUniqueFlag(UniqueValidateParam uniqueValidateParam) {
        try {
            return TableUniqueValueService.doValidate(uniqueValidateParam);
        }
        catch (Exception exception) {
            throw new ParamValidateException((AbstractExceptionEnum)ValidatorExceptionEnum.UNIQUE_VALIDATE_SQL_ERROR, new Object[]{exception.getMessage()});
        }
    }

    private static boolean doValidate(UniqueValidateParam uniqueValidateParam) {
        String finalSql;
        String sqlTemplate;
        DbOperatorApi dbOperatorApi = DbOperatorContext.me();
        int resultCount = 0;
        TableUniqueValueService.paramValidate(uniqueValidateParam);
        if (!uniqueValidateParam.getExcludeCurrentRecord().booleanValue() && !uniqueValidateParam.getExcludeLogicDeleteItems().booleanValue()) {
            sqlTemplate = "select count(*) from {} where {} = {0}";
            finalSql = StrUtil.format((CharSequence)sqlTemplate, (Object[])new Object[]{TableUniqueValueService.calcTenantTableName(uniqueValidateParam.getTableName()), uniqueValidateParam.getColumnName()});
            resultCount = dbOperatorApi.selectCount(finalSql, new Object[]{uniqueValidateParam.getValue()});
        }
        if (!uniqueValidateParam.getExcludeCurrentRecord().booleanValue() && uniqueValidateParam.getExcludeLogicDeleteItems().booleanValue()) {
            sqlTemplate = "select count(*) from {} where {} = {0}  and ({} is null or {} <> '{}')";
            finalSql = StrUtil.format((CharSequence)sqlTemplate, (Object[])new Object[]{TableUniqueValueService.calcTenantTableName(uniqueValidateParam.getTableName()), uniqueValidateParam.getColumnName(), uniqueValidateParam.getLogicDeleteFieldName(), uniqueValidateParam.getLogicDeleteFieldName(), uniqueValidateParam.getLogicDeleteValue()});
            resultCount = dbOperatorApi.selectCount(finalSql, new Object[]{uniqueValidateParam.getValue()});
        }
        if (uniqueValidateParam.getExcludeCurrentRecord().booleanValue() && !uniqueValidateParam.getExcludeLogicDeleteItems().booleanValue()) {
            TableUniqueValueService.paramIdValidate(uniqueValidateParam);
            sqlTemplate = "select count(*) from {} where {} = {0} and {} <> {1}";
            finalSql = StrUtil.format((CharSequence)sqlTemplate, (Object[])new Object[]{TableUniqueValueService.calcTenantTableName(uniqueValidateParam.getTableName()), uniqueValidateParam.getColumnName(), uniqueValidateParam.getIdFieldName()});
            resultCount = dbOperatorApi.selectCount(finalSql, new Object[]{uniqueValidateParam.getValue(), uniqueValidateParam.getId()});
        }
        if (uniqueValidateParam.getExcludeCurrentRecord().booleanValue() && uniqueValidateParam.getExcludeLogicDeleteItems().booleanValue()) {
            TableUniqueValueService.paramIdValidate(uniqueValidateParam);
            sqlTemplate = "select count(*) from {} where {} = {0} and {} <> {1} and ({} is null or {} <> '{}')";
            finalSql = StrUtil.format((CharSequence)sqlTemplate, (Object[])new Object[]{TableUniqueValueService.calcTenantTableName(uniqueValidateParam.getTableName()), uniqueValidateParam.getColumnName(), uniqueValidateParam.getIdFieldName(), uniqueValidateParam.getLogicDeleteFieldName(), uniqueValidateParam.getLogicDeleteFieldName(), uniqueValidateParam.getLogicDeleteValue()});
            resultCount = dbOperatorApi.selectCount(finalSql, new Object[]{uniqueValidateParam.getValue(), uniqueValidateParam.getId()});
        }
        return resultCount <= 0;
    }

    private static void paramValidate(UniqueValidateParam uniqueValidateParam) {
        if (StrUtil.isBlank((CharSequence)uniqueValidateParam.getTableName())) {
            throw new ParamValidateException((AbstractExceptionEnum)ValidatorExceptionEnum.TABLE_UNIQUE_VALIDATE_ERROR, new Object[]{"@TableUniqueValue\u6ce8\u89e3\u4e0atableName\u5c5e\u6027\u4e3a\u7a7a"});
        }
        if (StrUtil.isBlank((CharSequence)uniqueValidateParam.getColumnName())) {
            throw new ParamValidateException((AbstractExceptionEnum)ValidatorExceptionEnum.TABLE_UNIQUE_VALIDATE_ERROR, new Object[]{"@TableUniqueValue\u6ce8\u89e3\u4e0acolumnName\u5c5e\u6027\u4e3a\u7a7a"});
        }
        if (ObjectUtil.isEmpty((Object)uniqueValidateParam.getValue())) {
            throw new ParamValidateException((AbstractExceptionEnum)ValidatorExceptionEnum.TABLE_UNIQUE_VALIDATE_ERROR, new Object[]{"@TableUniqueValue\u88ab\u6821\u9a8c\u5c5e\u6027\u7684\u503c\u4e3a\u7a7a"});
        }
    }

    private static void paramIdValidate(UniqueValidateParam uniqueValidateParam) {
        if (uniqueValidateParam.getId() == null) {
            throw new ParamValidateException((AbstractExceptionEnum)ValidatorExceptionEnum.TABLE_UNIQUE_VALIDATE_ERROR, new Object[]{StrUtil.toCamelCase((CharSequence)uniqueValidateParam.getIdFieldName()) + "\u53c2\u6570\u503c\u4e3a\u7a7a"});
        }
    }

    private static String calcTenantTableName(String originTableName) {
        LoginUser loginUser = LoginContext.me().getLoginUser();
        String tenantCode = loginUser.getTenantCode();
        if (tenantCode == null || "master".equals(tenantCode)) {
            return originTableName;
        }
        return "sys_tenant_db_" + tenantCode + "." + originTableName;
    }
}

