/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.organization.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.enums.DataScopeTypeEnum;
import cn.stylefeng.roses.kernel.db.api.DbOperatorApi;
import cn.stylefeng.roses.kernel.db.api.context.DbOperatorContext;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.expand.modular.api.ExpandApi;
import cn.stylefeng.roses.kernel.rule.constants.TreeConstants;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.tree.factory.DefaultTreeBuildFactory;
import cn.stylefeng.roses.kernel.rule.tree.ztree.ZTreeNode;
import cn.stylefeng.roses.kernel.system.api.RoleDataScopeServiceApi;
import cn.stylefeng.roses.kernel.system.api.RoleServiceApi;
import cn.stylefeng.roses.kernel.system.api.UserOrgServiceApi;
import cn.stylefeng.roses.kernel.system.api.UserServiceApi;
import cn.stylefeng.roses.kernel.system.api.enums.DetectModeEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.organization.OrganizationExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.organization.HrOrganizationDTO;
import cn.stylefeng.roses.kernel.system.api.pojo.organization.HrOrganizationRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.organization.OrganizationTreeNode;
import cn.stylefeng.roses.kernel.system.api.util.DataScopeUtil;
import cn.stylefeng.roses.kernel.system.modular.organization.entity.HrOrganization;
import cn.stylefeng.roses.kernel.system.modular.organization.factory.OrganizationFactory;
import cn.stylefeng.roses.kernel.system.modular.organization.mapper.HrOrganizationMapper;
import cn.stylefeng.roses.kernel.system.modular.organization.service.HrOrganizationService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HrOrganizationServiceImpl
extends ServiceImpl<HrOrganizationMapper, HrOrganization>
implements HrOrganizationService {
    @Resource
    private UserOrgServiceApi userOrgServiceApi;
    @Resource
    private RoleServiceApi roleServiceApi;
    @Resource
    private UserServiceApi userServiceApi;
    @Resource
    private RoleDataScopeServiceApi roleDataScopeServiceApi;
    @Resource
    private ExpandApi expandApi;
    @Resource
    private DbOperatorApi dbOperatorApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(HrOrganizationRequest hrOrganizationRequest) {
        Long pid = hrOrganizationRequest.getOrgParentId();
        DataScopeUtil.quickValidateDataScope((Long)pid);
        HrOrganization hrOrganization = new HrOrganization();
        BeanUtil.copyProperties((Object)hrOrganizationRequest, (Object)((Object)hrOrganization), (String[])new String[0]);
        this.fillParentIds(hrOrganization);
        hrOrganization.setStatusFlag(StatusEnum.ENABLE.getCode());
        this.save((Object)hrOrganization);
        if (hrOrganizationRequest.getExpandDataInfo() != null) {
            hrOrganizationRequest.getExpandDataInfo().setPrimaryFieldValue(hrOrganization.getOrgId());
            this.expandApi.saveOrUpdateExpandData(hrOrganizationRequest.getExpandDataInfo());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(HrOrganizationRequest hrOrganizationRequest) {
        HrOrganization hrOrganization = this.queryOrganization(hrOrganizationRequest);
        Long organizationId = hrOrganization.getOrgId();
        DataScopeUtil.quickValidateDataScope((Long)organizationId);
        Boolean userOrgFlag = this.userOrgServiceApi.getUserOrgFlag(organizationId, null);
        if (userOrgFlag.booleanValue()) {
            throw new SystemModularException((AbstractExceptionEnum)OrganizationExceptionEnum.DELETE_ORGANIZATION_ERROR);
        }
        Set childIdList = DbOperatorContext.me().findSubListByParentId("hr_organization", "org_pids", "org_id", organizationId);
        childIdList.add(organizationId);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.in(HrOrganization::getOrgId, (Collection)childIdList)).set(HrOrganization::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        this.update((Wrapper)updateWrapper);
        this.roleDataScopeServiceApi.delByOrgIds(childIdList);
        this.userServiceApi.deleteUserDataScopeListByOrgIdList(childIdList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void edit(HrOrganizationRequest hrOrganizationRequest) {
        HrOrganization hrOrganization = this.queryOrganization(hrOrganizationRequest);
        Long id = hrOrganization.getOrgId();
        DataScopeUtil.quickValidateDataScope((Long)id);
        BeanUtil.copyProperties((Object)hrOrganizationRequest, (Object)((Object)hrOrganization), (String[])new String[0]);
        this.fillParentIds(hrOrganization);
        hrOrganization.setStatusFlag(null);
        this.updateById((Object)hrOrganization);
        if (hrOrganizationRequest.getExpandDataInfo() != null) {
            hrOrganizationRequest.getExpandDataInfo().setPrimaryFieldValue(hrOrganization.getOrgId());
            this.expandApi.saveOrUpdateExpandData(hrOrganizationRequest.getExpandDataInfo());
        }
    }

    @Override
    public void updateStatus(HrOrganizationRequest hrOrganizationRequest) {
        HrOrganization hrOrganization = this.queryOrganization(hrOrganizationRequest);
        hrOrganization.setStatusFlag(hrOrganizationRequest.getStatusFlag());
        this.updateById((Object)hrOrganization);
    }

    @Override
    public HrOrganization detail(HrOrganizationRequest hrOrganizationRequest) {
        return (HrOrganization)((Object)this.getOne((Wrapper)this.createWrapper(hrOrganizationRequest), false));
    }

    @Override
    public PageResult<HrOrganization> findPage(HrOrganizationRequest hrOrganizationRequest) {
        LambdaQueryWrapper<HrOrganization> wrapper = this.createWrapper(hrOrganizationRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<HrOrganization> findList(HrOrganizationRequest hrOrganizationRequest) {
        LambdaQueryWrapper<HrOrganization> wrapper = this.createWrapper(hrOrganizationRequest);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<OrganizationTreeNode> organizationTree(HrOrganizationRequest hrOrganizationRequest) {
        List orgIds;
        ArrayList treeNodeList = CollectionUtil.newArrayList((Object[])new OrganizationTreeNode[0]);
        List<HrOrganization> hrOrganizationList = this.findListByDataScope(hrOrganizationRequest);
        for (HrOrganization hrOrganization : hrOrganizationList) {
            OrganizationTreeNode treeNode = OrganizationFactory.parseOrganizationTreeNode(hrOrganization);
            treeNodeList.add(treeNode);
        }
        if (hrOrganizationRequest.getUserId() != null && ObjectUtil.isNotEmpty((Object)(orgIds = this.userServiceApi.getUserBindDataScope(hrOrganizationRequest.getUserId())))) {
            for (OrganizationTreeNode organizationTreeNode : treeNodeList) {
                for (Long orgId : orgIds) {
                    if (!organizationTreeNode.getId().equals(orgId)) continue;
                    organizationTreeNode.setSelected(true);
                }
            }
        }
        if (ObjectUtil.isNotEmpty((Object)hrOrganizationRequest.getOrgName()) || ObjectUtil.isNotEmpty((Object)hrOrganizationRequest.getOrgCode())) {
            return treeNodeList;
        }
        return new DefaultTreeBuildFactory().doTreeBuild((List)treeNodeList);
    }

    @Override
    public List<ZTreeNode> orgZTree(HrOrganizationRequest hrOrganizationRequest, boolean buildTree) {
        Long roleId = hrOrganizationRequest.getRoleId();
        LambdaQueryWrapper<HrOrganization> wrapper = this.createWrapper(hrOrganizationRequest);
        List list2 = this.list((Wrapper)wrapper);
        List<ZTreeNode> zTreeNodes = OrganizationFactory.parseZTree(list2);
        List roleDataScopes = this.roleServiceApi.getRoleDataScopes((List)ListUtil.toList((Object[])new Long[]{roleId}));
        for (ZTreeNode zTreeNode : zTreeNodes) {
            if (!roleDataScopes.contains(zTreeNode.getId())) continue;
            zTreeNode.setChecked(Boolean.valueOf(true));
        }
        if (buildTree) {
            return new DefaultTreeBuildFactory().doTreeBuild(zTreeNodes);
        }
        return zTreeNodes;
    }

    @Override
    public Set<Long> findAllLevelParentIdsByOrganizations(Set<Long> organizationIds) {
        HashSet<Long> allLevelParentIds = new HashSet<Long>(organizationIds);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(HrOrganization::getOrgId, organizationIds);
        queryWrapper.select(new SFunction[]{HrOrganization::getOrgPids});
        List organizationList = this.list((Wrapper)queryWrapper);
        if (organizationList == null || organizationList.isEmpty()) {
            return allLevelParentIds;
        }
        for (HrOrganization hrOrganization : organizationList) {
            String[] finalPidArray;
            String pids = hrOrganization.getOrgPids();
            pids = StrUtil.removeAll((CharSequence)pids, (CharSequence)"[");
            pids = StrUtil.removeAll((CharSequence)pids, (CharSequence)"]");
            for (String pid : finalPidArray = pids.split(",")) {
                allLevelParentIds.add(Convert.toLong((Object)pid));
            }
        }
        return allLevelParentIds;
    }

    public List<HrOrganizationDTO> orgList() {
        Set dataScopeTypes;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        boolean needToDataScope = true;
        if (LoginContext.me().getSuperAdminFlag() && (dataScopeTypes = LoginContext.me().getLoginUser().getDataScopeTypeEnums()) != null && dataScopeTypes.contains(DataScopeTypeEnum.ALL)) {
            needToDataScope = false;
        }
        if (needToDataScope) {
            Set dataScope = LoginContext.me().getLoginUser().getDataScopeOrganizationIds();
            if (ObjectUtil.isEmpty((Object)dataScope)) {
                return new ArrayList<HrOrganizationDTO>();
            }
            Set<Long> allLevelParentIdsByOrganizations = this.findAllLevelParentIdsByOrganizations(dataScope);
            queryWrapper.in(HrOrganization::getOrgId, allLevelParentIdsByOrganizations);
        }
        queryWrapper.eq(HrOrganization::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        queryWrapper.orderByAsc(HrOrganization::getOrgSort);
        Function<Object, HrOrganizationDTO> mapper = e -> {
            HrOrganizationDTO org = new HrOrganizationDTO();
            HrOrganization hrOrg = (HrOrganization)((Object)((Object)e));
            BeanUtil.copyProperties((Object)((Object)hrOrg), (Object)org, (String[])new String[0]);
            return org;
        };
        List list2 = this.list((Wrapper)queryWrapper);
        return list2.stream().filter(Objects::nonNull).map(mapper).collect(Collectors.toList());
    }

    public HrOrganizationDTO getOrgDetail(Long orgId) {
        HrOrganizationDTO hrOrganizationDTO = new HrOrganizationDTO();
        HrOrganizationRequest request = new HrOrganizationRequest();
        request.setOrgId(orgId);
        HrOrganization detail2 = this.detail(request);
        if (ObjectUtil.isNotNull((Object)((Object)detail2))) {
            BeanUtil.copyProperties((Object)((Object)detail2), (Object)hrOrganizationDTO, (CopyOptions)CopyOptions.create().ignoreError());
        }
        return hrOrganizationDTO;
    }

    public List<HrOrganizationDTO> getOrgDetailList(List<Long> orgIdList) {
        ArrayList<HrOrganizationDTO> organizationDTOS = new ArrayList<HrOrganizationDTO>();
        for (Long orgId : orgIdList) {
            HrOrganizationDTO orgDetail = this.getOrgDetail(orgId);
            organizationDTOS.add(orgDetail);
        }
        return organizationDTOS;
    }

    public List<OrganizationTreeNode> getOrgTreeList(HrOrganizationRequest hrOrganizationRequest) {
        ArrayList treeNodeList = CollectionUtil.newArrayList((Object[])new OrganizationTreeNode[0]);
        LambdaQueryWrapper<HrOrganization> wrapper = this.createWrapper(hrOrganizationRequest);
        List hrOrganizationList = this.list((Wrapper)wrapper);
        for (HrOrganization hrOrganization : hrOrganizationList) {
            OrganizationTreeNode treeNode = OrganizationFactory.parseOrganizationTreeNode(hrOrganization);
            treeNodeList.add(treeNode);
        }
        return new DefaultTreeBuildFactory().doTreeBuild((List)treeNodeList);
    }

    public List<OrganizationTreeNode> getDeptOrgTree(Long orgId) {
        Set deptIds = this.dbOperatorApi.findSubListByParentId("hr_organization", "org_pids", "org_id", orgId);
        deptIds.add(orgId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(HrOrganization::getOrgId, (Collection)deptIds);
        List hrOrganizationList = this.list((Wrapper)wrapper);
        ArrayList treeNodeList = CollectionUtil.newArrayList((Object[])new OrganizationTreeNode[0]);
        for (HrOrganization hrOrganization : hrOrganizationList) {
            OrganizationTreeNode treeNode = OrganizationFactory.parseOrganizationTreeNode(hrOrganization);
            treeNodeList.add(treeNode);
        }
        return new DefaultTreeBuildFactory().doTreeBuild((List)treeNodeList);
    }

    public Long getParentLevelOrgId(Long orgId, Integer parentLevelNum, DetectModeEnum detectModeEnum) {
        if (DetectModeEnum.TO_TOP.equals((Object)detectModeEnum)) {
            return this.calcParentOrgId(orgId, parentLevelNum, true);
        }
        return this.calcParentOrgId(orgId, parentLevelNum, false);
    }

    private LambdaQueryWrapper<HrOrganization> createWrapper(HrOrganizationRequest hrOrganizationRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(HrOrganization::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        queryWrapper.orderByAsc(HrOrganization::getOrgSort);
        if (ObjectUtil.isEmpty((Object)hrOrganizationRequest)) {
            return queryWrapper;
        }
        String orgName = hrOrganizationRequest.getOrgName();
        String orgCode = hrOrganizationRequest.getOrgCode();
        Long orgParentId = hrOrganizationRequest.getOrgParentId();
        Long orgId = hrOrganizationRequest.getOrgId();
        Integer orgType = hrOrganizationRequest.getOrgType();
        String taxNo = hrOrganizationRequest.getTaxNo();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)orgName), HrOrganization::getOrgName, (Object)orgName);
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)orgCode), HrOrganization::getOrgCode, (Object)orgCode);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)orgType), HrOrganization::getOrgType, (Object)orgType);
        queryWrapper.eq(StrUtil.isNotEmpty((CharSequence)taxNo), HrOrganization::getTaxNo, (Object)taxNo);
        if (ObjectUtil.isNotEmpty((Object)orgParentId)) {
            queryWrapper.and(qw -> ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(HrOrganization::getOrgId, (Object)orgParentId)).or()).like(HrOrganization::getOrgPids, (Object)orgParentId));
        }
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)orgId), HrOrganization::getOrgId, (Object)orgId);
        List orgIdLimit = hrOrganizationRequest.getOrgIdLimit();
        if (ObjectUtil.isNotEmpty((Object)orgIdLimit)) {
            queryWrapper.nested(qw -> {
                for (Long itemOrgId : orgIdLimit) {
                    ((LambdaQueryWrapper)qw.or()).like(HrOrganization::getOrgPids, (Object)itemOrgId);
                }
            });
        }
        return queryWrapper;
    }

    private HrOrganization queryOrganization(HrOrganizationRequest hrOrganizationRequest) {
        HrOrganization hrOrganization = (HrOrganization)((Object)this.getById(hrOrganizationRequest.getOrgId()));
        if (ObjectUtil.isEmpty((Object)((Object)hrOrganization))) {
            throw new SystemModularException((AbstractExceptionEnum)OrganizationExceptionEnum.CANT_FIND_ORG, new Object[]{hrOrganizationRequest.getOrgId()});
        }
        return hrOrganization;
    }

    private void fillParentIds(HrOrganization hrOrganization) {
        if (TreeConstants.DEFAULT_PARENT_ID.equals(hrOrganization.getOrgParentId())) {
            hrOrganization.setOrgPids("[" + TreeConstants.DEFAULT_PARENT_ID + "]" + ",");
        } else {
            HrOrganizationRequest hrOrganizationRequest = new HrOrganizationRequest();
            hrOrganizationRequest.setOrgId(hrOrganization.getOrgParentId());
            HrOrganization parentOrganization = this.queryOrganization(hrOrganizationRequest);
            hrOrganization.setOrgPids(parentOrganization.getOrgPids() + "[" + parentOrganization.getOrgId() + "]" + ",");
        }
    }

    private List<HrOrganization> findListByDataScope(HrOrganizationRequest hrOrganizationRequest) {
        LambdaQueryWrapper<HrOrganization> queryWrapper = this.createWrapper(hrOrganizationRequest);
        boolean needToDataScope = true;
        Set dataScopeTypes = LoginContext.me().getLoginUser().getDataScopeTypeEnums();
        if (LoginContext.me().getSuperAdminFlag() || dataScopeTypes != null && dataScopeTypes.contains(DataScopeTypeEnum.ALL)) {
            needToDataScope = false;
        }
        if (needToDataScope) {
            Set dataScope = LoginContext.me().getLoginUser().getDataScopeOrganizationIds();
            if (ObjectUtil.isEmpty((Object)dataScope)) {
                return new ArrayList<HrOrganization>();
            }
            Set<Long> allLevelParentIdsByOrganizations = this.findAllLevelParentIdsByOrganizations(dataScope);
            queryWrapper.in(HrOrganization::getOrgId, allLevelParentIdsByOrganizations);
        }
        return this.list((Wrapper)queryWrapper);
    }

    private Long calcParentOrgId(Long orgId, Integer parentLevelNum, boolean reverse) {
        String orgIdString;
        if (ObjectUtil.isEmpty((Object)orgId) || ObjectUtil.isEmpty((Object)parentLevelNum)) {
            return null;
        }
        if (parentLevelNum == 0) {
            return orgId;
        }
        HrOrganization hrOrganization = (HrOrganization)((Object)this.getById(orgId));
        if (hrOrganization == null || StrUtil.isEmpty((CharSequence)hrOrganization.getOrgPids())) {
            return null;
        }
        String orgParentIdListStr = hrOrganization.getOrgPids();
        orgParentIdListStr = orgParentIdListStr.replaceAll("\\[", "");
        orgParentIdListStr = orgParentIdListStr.replaceAll("]", "");
        Object[] orgParentIdList = orgParentIdListStr.split(",");
        if (reverse) {
            orgParentIdList = (String[])ArrayUtil.reverse((Object[])orgParentIdList);
        }
        ArrayList<Object> parentOrgIdList = new ArrayList<Object>();
        for (Object orgIdItem : orgParentIdList) {
            if (TreeConstants.DEFAULT_PARENT_ID.toString().equals(orgIdItem)) continue;
            parentOrgIdList.add(orgIdItem);
        }
        int needGetArrayIndex = parentLevelNum - 1;
        int maxCanGetIndex = parentOrgIdList.size() - 1;
        if (maxCanGetIndex < 0) {
            return orgId;
        }
        if (needGetArrayIndex <= maxCanGetIndex) {
            orgIdString = (String)parentOrgIdList.get(needGetArrayIndex);
        } else if (reverse) {
            orgIdString = (String)parentOrgIdList.get(maxCanGetIndex);
        } else {
            return orgId;
        }
        return Long.valueOf(orgIdString);
    }
}

