/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.notice.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.entity.BaseEntity;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.message.api.MessageApi;
import cn.stylefeng.roses.kernel.message.api.enums.MessageBusinessTypeEnum;
import cn.stylefeng.roses.kernel.message.api.pojo.request.MessageSendRequest;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.notice.NoticeExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.notice.SysNoticeRequest;
import cn.stylefeng.roses.kernel.system.modular.notice.entity.SysNotice;
import cn.stylefeng.roses.kernel.system.modular.notice.mapper.SysNoticeMapper;
import cn.stylefeng.roses.kernel.system.modular.notice.service.SysNoticeService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysNoticeServiceImpl
extends ServiceImpl<SysNoticeMapper, SysNotice>
implements SysNoticeService {
    private static final String NOTICE_SCOPE_ALL = "all";
    @Resource
    private MessageApi messageApi;

    @Override
    public void add(SysNoticeRequest sysNoticeRequest) {
        SysNotice sysNotice = new SysNotice();
        BeanUtil.copyProperties((Object)sysNoticeRequest, (Object)((Object)sysNotice), (String[])new String[0]);
        if (StrUtil.isBlank((CharSequence)sysNotice.getNoticeScope())) {
            sysNotice.setNoticeScope(NOTICE_SCOPE_ALL);
        }
        if (this.save((Object)sysNotice)) {
            this.sendMessage(sysNotice);
        }
    }

    @Override
    public void del(SysNoticeRequest sysNoticeRequest) {
        SysNotice sysNotice = this.querySysNoticeById(sysNoticeRequest);
        sysNotice.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysNotice);
    }

    @Override
    public void edit(SysNoticeRequest sysNoticeRequest) {
        SysNotice sysNotice = this.querySysNoticeById(sysNoticeRequest);
        if (!sysNoticeRequest.getNoticeScope().equals(sysNotice.getNoticeScope())) {
            throw new SystemModularException((AbstractExceptionEnum)NoticeExceptionEnum.NOTICE_SCOPE_NOT_EDIT);
        }
        String noticeScope = sysNotice.getNoticeScope();
        if (StrUtil.isBlank((CharSequence)noticeScope)) {
            sysNoticeRequest.setNoticeScope(NOTICE_SCOPE_ALL);
        }
        BeanUtil.copyProperties((Object)sysNoticeRequest, (Object)((Object)sysNotice), (String[])new String[0]);
        if (this.updateById((Object)sysNotice)) {
            this.sendMessage(sysNotice);
        }
    }

    @Override
    public SysNotice detail(SysNoticeRequest sysNoticeRequest) {
        LambdaQueryWrapper<SysNotice> queryWrapper = this.createWrapper(sysNoticeRequest);
        return (SysNotice)((Object)this.getOne((Wrapper)queryWrapper, false));
    }

    @Override
    public PageResult<SysNotice> findPage(SysNoticeRequest sysNoticeRequest) {
        LambdaQueryWrapper<SysNotice> wrapper = this.createWrapper(sysNoticeRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysNotice> findList(SysNoticeRequest sysNoticeRequest) {
        LambdaQueryWrapper<SysNotice> wrapper = this.createWrapper(sysNoticeRequest);
        return this.list((Wrapper)wrapper);
    }

    private SysNotice querySysNoticeById(SysNoticeRequest sysNoticeRequest) {
        SysNotice sysNotice = (SysNotice)((Object)this.getById(sysNoticeRequest.getNoticeId()));
        if (ObjectUtil.isNull((Object)((Object)sysNotice))) {
            throw new SystemModularException((AbstractExceptionEnum)NoticeExceptionEnum.NOTICE_NOT_EXIST, new Object[]{sysNoticeRequest.getNoticeId()});
        }
        return sysNotice;
    }

    private LambdaQueryWrapper<SysNotice> createWrapper(SysNoticeRequest sysNoticeRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(BaseEntity::getCreateTime);
        queryWrapper.eq(SysNotice::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        if (ObjectUtil.isEmpty((Object)sysNoticeRequest)) {
            return queryWrapper;
        }
        Long noticeId = sysNoticeRequest.getNoticeId();
        String noticeTitle = sysNoticeRequest.getNoticeTitle();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)noticeTitle), SysNotice::getNoticeTitle, (Object)noticeTitle);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)noticeId), SysNotice::getNoticeId, (Object)noticeId);
        return queryWrapper;
    }

    private void sendMessage(SysNotice sysNotice) {
        MessageSendRequest message = new MessageSendRequest();
        message.setMessageTitle(sysNotice.getNoticeTitle());
        message.setMessageContent(sysNotice.getNoticeContent());
        message.setPriorityLevel(sysNotice.getPriorityLevel());
        message.setReceiveUserIds(sysNotice.getNoticeScope());
        message.setBusinessType(MessageBusinessTypeEnum.SYS_NOTICE.getCode());
        message.setBusinessTypeValue(MessageBusinessTypeEnum.SYS_NOTICE.getName());
        message.setBusinessId(sysNotice.getNoticeId());
        message.setMessageSendTime(new Date());
        try {
            this.messageApi.sendMessage(message);
        }
        catch (Exception exception) {
            this.log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25:", (Throwable)exception);
        }
    }
}

