/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.home.aop;

import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.auth.api.pojo.login.LoginUser;
import cn.stylefeng.roses.kernel.cache.api.CacheOperatorApi;
import cn.stylefeng.roses.kernel.rule.util.HttpServletUtil;
import cn.stylefeng.roses.kernel.system.api.constants.StatisticsCacheConstants;
import cn.stylefeng.roses.kernel.system.modular.home.context.StatisticsUrlContext;
import cn.stylefeng.roses.kernel.system.modular.home.entity.SysStatisticsUrl;
import cn.stylefeng.roses.kernel.system.modular.home.service.SysStatisticsCountService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

@Aspect
public class InterfaceStatisticsAop
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(InterfaceStatisticsAop.class);
    @Resource(name="requestCountCacheApi")
    private CacheOperatorApi<Map<Long, Integer>> requestCountCacheApi;
    @Resource
    private SysStatisticsCountService sysStatisticsCountService;

    @Pointcut(value="execution(* *..controller.*.*(..)) || execution(* *..*Controller.*(..))")
    public void flowControl() {
    }

    @Around(value="flowControl()")
    public Object flowControl(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed = joinPoint.proceed();
        try {
            this.saveRequestCount();
        }
        catch (Exception e) {
            log.error("\u63a5\u53e3\u7edf\u8ba1\u51fa\u73b0\u5f02\u5e38\uff01", (Throwable)e);
        }
        return proceed;
    }

    private void saveRequestCount() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        String currentUrl = request.getRequestURI();
        LoginUser loginUserNullable = LoginContext.me().getLoginUserNullable();
        if (loginUserNullable == null) {
            return;
        }
        List<SysStatisticsUrl> urls = StatisticsUrlContext.getUrls();
        if (urls.stream().noneMatch(i -> currentUrl.equals(i.getStatUrl()))) {
            return;
        }
        Long userId = loginUserNullable.getUserId();
        Long statUrlId = StatisticsUrlContext.getStatUrlId(currentUrl);
        Map userStatList = null;
        userStatList = !this.requestCountCacheApi.contains(String.valueOf(userId)) ? new HashMap() : (Map)this.requestCountCacheApi.get(String.valueOf(userId));
        Integer urlCount = (Integer)userStatList.get(statUrlId);
        if (urlCount != null) {
            int newUrlCount = urlCount + 1;
            userStatList.put(statUrlId, newUrlCount);
        } else {
            Integer userUrlCount = this.sysStatisticsCountService.getUserUrlCount(userId, statUrlId);
            userStatList.put(statUrlId, userUrlCount);
        }
        this.requestCountCacheApi.put(String.valueOf(userId), userStatList, StatisticsCacheConstants.INTERFACE_STATISTICS_CACHE_TIMEOUT_SECONDS);
    }

    public int getOrder() {
        return 600;
    }
}

