/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.system.modular.app.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.rule.exception.base.ServiceException;
import cn.stylefeng.roses.kernel.rule.pojo.dict.SimpleDict;
import cn.stylefeng.roses.kernel.system.api.AppServiceApi;
import cn.stylefeng.roses.kernel.system.api.MenuServiceApi;
import cn.stylefeng.roses.kernel.system.api.exception.SystemModularException;
import cn.stylefeng.roses.kernel.system.api.exception.enums.app.AppExceptionEnum;
import cn.stylefeng.roses.kernel.system.api.pojo.app.SysAppRequest;
import cn.stylefeng.roses.kernel.system.api.pojo.app.SysAppResult;
import cn.stylefeng.roses.kernel.system.modular.app.entity.SysApp;
import cn.stylefeng.roses.kernel.system.modular.app.mapper.SysAppMapper;
import cn.stylefeng.roses.kernel.system.modular.app.service.SysAppService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysAppServiceImpl
extends ServiceImpl<SysAppMapper, SysApp>
implements SysAppService,
AppServiceApi {
    @Resource
    private MenuServiceApi menuApi;

    @Override
    public void add(SysAppRequest sysAppRequest) {
        SysApp sysApp = new SysApp();
        sysApp.setAppName(sysAppRequest.getAppName());
        sysApp.setAppCode(sysAppRequest.getAppCode());
        sysApp.setAppIcon(sysAppRequest.getAppIcon());
        if (sysAppRequest.getAppSort() == null) {
            sysApp.setAppSort(999);
        }
        sysApp.setActiveFlag(YesOrNotEnum.N.getCode());
        sysApp.setStatusFlag(StatusEnum.ENABLE.getCode());
        this.save((Object)sysApp);
    }

    @Override
    public void del(SysAppRequest sysAppRequest) {
        SysApp sysApp = this.querySysApp(sysAppRequest);
        String code = sysApp.getAppCode();
        boolean hasMenu = this.menuApi.hasMenu(code);
        if (hasMenu) {
            throw new ServiceException((AbstractExceptionEnum)AppExceptionEnum.APP_CANNOT_DELETE);
        }
        sysApp.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysApp);
    }

    @Override
    public void edit(SysAppRequest sysAppRequest) {
        SysApp sysApp = this.querySysApp(sysAppRequest);
        BeanUtil.copyProperties((Object)sysAppRequest, (Object)((Object)sysApp), (String[])new String[0]);
        sysApp.setAppCode(null);
        sysApp.setStatusFlag(null);
        sysApp.setActiveFlag(null);
        this.updateById((Object)sysApp);
    }

    @Override
    public void editStatus(SysAppRequest sysAppParam) {
        SysApp currentApp = this.querySysApp(sysAppParam);
        if (YesOrNotEnum.Y.getCode().equals(currentApp.getActiveFlag()) && StatusEnum.DISABLE.getCode().equals(sysAppParam.getStatusFlag())) {
            throw new SystemModularException((AbstractExceptionEnum)AppExceptionEnum.CANT_DISABLE);
        }
        currentApp.setStatusFlag(sysAppParam.getStatusFlag());
        this.updateById((Object)currentApp);
    }

    @Override
    public SysApp detail(SysAppRequest sysAppRequest) {
        return this.querySysApp(sysAppRequest);
    }

    @Override
    public List<SysApp> findList(SysAppRequest sysAppRequest) {
        LambdaQueryWrapper<SysApp> wrapper = this.createWrapper(sysAppRequest);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public PageResult<SysApp> findPage(SysAppRequest sysAppRequest) {
        LambdaQueryWrapper<SysApp> wrapper = this.createWrapper(sysAppRequest);
        wrapper.orderByAsc(SysApp::getAppSort);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateActiveFlag(SysAppRequest sysAppRequest) {
        SysApp currentApp = this.querySysApp(sysAppRequest);
        boolean hasMenu = this.menuApi.hasMenu(currentApp.getAppCode());
        if (!hasMenu) {
            throw new ServiceException((AbstractExceptionEnum)AppExceptionEnum.ACTIVE_ERROR);
        }
        LambdaUpdateWrapper sysAppLambdaUpdateWrapper = new LambdaUpdateWrapper();
        sysAppLambdaUpdateWrapper.set(SysApp::getActiveFlag, (Object)YesOrNotEnum.N.getCode());
        sysAppLambdaUpdateWrapper.eq(SysApp::getActiveFlag, (Object)YesOrNotEnum.Y.getCode());
        this.update((Wrapper)sysAppLambdaUpdateWrapper);
        currentApp.setActiveFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)currentApp);
    }

    @Override
    public List<SysApp> getUserTopAppList() {
        List userAppCodeList = this.menuApi.getUserAppCodeList();
        LambdaQueryWrapper<SysApp> wrapper = this.createWrapper(null);
        wrapper.in(SysApp::getAppCode, (Collection)userAppCodeList);
        wrapper.select(new SFunction[]{SysApp::getAppName, SysApp::getAppCode});
        wrapper.orderByDesc(SysApp::getActiveFlag);
        return this.list((Wrapper)wrapper);
    }

    public Set<SimpleDict> getAppsByAppCodes(Set<String> appCodes) {
        HashSet<SimpleDict> simpleDicts = new HashSet<SimpleDict>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysApp::getAppCode, appCodes);
        queryWrapper.select(new SFunction[]{SysApp::getAppId, SysApp::getAppCode, SysApp::getAppName});
        List list = this.list((Wrapper)queryWrapper);
        for (SysApp sysApp : list) {
            SimpleDict simpleDict = new SimpleDict();
            simpleDict.setId(sysApp.getAppId());
            simpleDict.setCode(sysApp.getAppCode());
            simpleDict.setName(sysApp.getAppName());
            simpleDicts.add(simpleDict);
        }
        return simpleDicts;
    }

    public String getAppNameByAppCode(String appCode) {
        String emptyName = "\u7a7a\u5e94\u7528";
        if (ObjectUtil.isEmpty((Object)appCode)) {
            return emptyName;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysApp::getAppCode, (Object)appCode);
        lambdaQueryWrapper.select(new SFunction[]{SysApp::getAppName});
        SysApp sysApp = (SysApp)((Object)this.getOne((Wrapper)lambdaQueryWrapper));
        if (sysApp == null || ObjectUtil.isEmpty((Object)sysApp.getAppName())) {
            return emptyName;
        }
        return sysApp.getAppName();
    }

    public String getActiveAppCode() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{SysApp::getAppCode});
        queryWrapper.eq(SysApp::getActiveFlag, (Object)YesOrNotEnum.Y.getCode());
        queryWrapper.eq(SysApp::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        List list = this.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            return null;
        }
        return ((SysApp)((Object)list.get(0))).getAppCode();
    }

    public SysAppResult getAppInfoByAppCode(String appCode) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysApp::getAppCode, (Object)appCode);
        SysApp sysApp = (SysApp)((Object)this.getOne((Wrapper)lambdaQueryWrapper, false));
        if (sysApp != null) {
            SysAppResult sysAppResult = new SysAppResult();
            BeanUtil.copyProperties((Object)((Object)sysApp), (Object)sysAppResult, (String[])new String[0]);
            return sysAppResult;
        }
        return new SysAppResult();
    }

    private SysApp querySysApp(SysAppRequest sysAppRequest) {
        SysApp sysApp = (SysApp)((Object)this.getById(sysAppRequest.getAppId()));
        if (ObjectUtil.isNull((Object)((Object)sysApp))) {
            throw new ServiceException((AbstractExceptionEnum)AppExceptionEnum.APP_NOT_EXIST);
        }
        return sysApp;
    }

    private LambdaQueryWrapper<SysApp> createWrapper(SysAppRequest sysAppRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysApp::getDelFlag, (Object)YesOrNotEnum.N.getCode());
        if (ObjectUtil.isEmpty((Object)sysAppRequest)) {
            return queryWrapper;
        }
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)sysAppRequest.getAppId()), SysApp::getAppId, (Object)sysAppRequest.getAppId());
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)sysAppRequest.getAppName()), SysApp::getAppName, (Object)sysAppRequest.getAppName());
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)sysAppRequest.getAppCode()), SysApp::getAppCode, (Object)sysAppRequest.getAppCode());
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)sysAppRequest.getStatusFlag()), SysApp::getActiveFlag, (Object)sysAppRequest.getActiveFlag());
        return queryWrapper;
    }
}

