/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.request.encrypt.advice;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import cn.stylefeng.roses.kernel.rule.pojo.response.ResponseData;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.security.request.encrypt.holder.EncryptionHolder;
import com.alibaba.fastjson.JSON;
import com.sun.crypto.provider.SunJCE;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class EncryptionResponseBodyAdvice
implements ResponseBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(EncryptionResponseBodyAdvice.class);

    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        PostResource annotation;
        if (null != body && (annotation = returnType.getMethod().getAnnotation(PostResource.class)) != null && annotation.requiredEncryption() && body instanceof ResponseData) {
            ResponseData responseData = (ResponseData)body;
            Object data = responseData.getData();
            String respJsonStr = JSON.toJSONString((Object)data);
            String aesKey = EncryptionHolder.getAesKey();
            byte[] iv = HexUtil.decodeHex((String)SecureUtil.md5((String)StrUtil.format((CharSequence)"{}{}", (Object[])new Object[]{aesKey, DateUtil.format((Date)new Date(), (String)"yyyyMMdd")})));
            if (StrUtil.isNotBlank((CharSequence)aesKey)) {
                byte[] keyByte = Base64.decode((byte[])aesKey.getBytes(CharsetUtil.CHARSET_UTF_8));
                AES aes = new AES("CFB", "PKCS7Padding", keyByte, iv);
                String encryptBase64 = aes.encryptBase64(respJsonStr);
                responseData.setData((Object)encryptBase64);
            }
            EncryptionHolder.clearAesKey();
            return responseData;
        }
        return body;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new SunJCE());
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

