/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.security.request.encrypt.advice;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.crypto.symmetric.SM4;
import cn.stylefeng.roses.kernel.scanner.api.annotation.PostResource;
import cn.stylefeng.roses.kernel.security.request.encrypt.exception.EncryptionException;
import cn.stylefeng.roses.kernel.security.request.encrypt.exception.enums.EncryptionExceptionEnum;
import cn.stylefeng.roses.kernel.security.request.encrypt.holder.EncryptionHolder;
import cn.stylefeng.roses.kernel.security.request.encrypt.holder.EncryptionRsaHolder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.sun.crypto.provider.SunJCE;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.Provider;
import java.security.Security;
import java.util.Date;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
public class EncryptionRequestBodyAdvice
implements RequestBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(EncryptionRequestBodyAdvice.class);

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        int n = 0;
        Annotation[] annotations = methodParameter.getAnnotatedElement().getAnnotations();
        Annotation[] annotationArray = annotations;
        int n2 = annotationArray.length;
        if (n < n2) {
            Annotation annotation = annotationArray[n];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            return PostResource.class.equals(annotationType);
        }
        return false;
    }

    public HttpInputMessage beforeBodyRead(final HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        PostResource annotation;
        Method method = parameter.getMethod();
        if (method != null && (annotation = method.getAnnotation(PostResource.class)) != null && annotation.requiredEncryption()) {
            return new HttpInputMessage(){

                public HttpHeaders getHeaders() {
                    return inputMessage.getHeaders();
                }

                public InputStream getBody() throws IOException {
                    InputStream body = inputMessage.getBody();
                    String bodyStr = IoUtil.readUtf8((InputStream)body);
                    JSONObject jsonObject = null;
                    try {
                        jsonObject = JSON.parseObject((String)bodyStr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error(e.getMessage());
                        log.error(StrUtil.format((CharSequence)"\u8bf7\u6c42\u7684\u5185\u5bb9\uff1a{}", (Object[])new Object[]{bodyStr}));
                        throw new EncryptionException(EncryptionExceptionEnum.REQUEST_JSON_PARSE_ERROR);
                    }
                    RSA rsa = EncryptionRsaHolder.getRsa();
                    String objectString = jsonObject.getString("data");
                    if (StrUtil.isBlank((CharSequence)objectString)) {
                        throw new EncryptionException(EncryptionExceptionEnum.REQUEST_JSON_PARSE_ERROR);
                    }
                    String sm4Key = SecureUtil.md5((String)DateUtil.format((Date)new Date(), (String)"yyyyMMdd"));
                    SM4 sm4 = new SM4(Mode.ECB, Padding.PKCS5Padding, HexUtil.decodeHex((String)sm4Key));
                    try {
                        String decryptStr = sm4.decryptStr(objectString);
                        jsonObject = JSON.parseObject((String)decryptStr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error(e.getMessage());
                        throw new EncryptionException(EncryptionExceptionEnum.RSA_DECRYPT_ERROR);
                    }
                    String key = jsonObject.getString("key");
                    String data = jsonObject.getString("data");
                    if (StrUtil.isBlank((CharSequence)key) || StrUtil.isBlank((CharSequence)data)) {
                        throw new EncryptionException(EncryptionExceptionEnum.REQUEST_JSON_ERROR);
                    }
                    String aesKey = null;
                    try {
                        aesKey = rsa.decryptStr(key, KeyType.PrivateKey, CharsetUtil.CHARSET_UTF_8);
                        log.info("\u672c\u6b21\u8bf7\u6c42\u6570\u636eAES\u52a0\u5bc6\u7684KEY\u4e3a\uff1a" + aesKey);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error(e.getMessage());
                        throw new EncryptionException(EncryptionExceptionEnum.RSA_DECRYPT_ERROR);
                    }
                    byte[] iv = HexUtil.decodeHex((String)SecureUtil.md5((String)StrUtil.format((CharSequence)"{}{}", (Object[])new Object[]{aesKey, DateUtil.format((Date)new Date(), (String)"yyyyMMdd")})));
                    byte[] aesKeyByte = Base64.decode((CharSequence)aesKey);
                    AES aes = new AES("CFB", "PKCS7Padding", aesKeyByte, iv);
                    String reqData = null;
                    try {
                        reqData = aes.decryptStr(data);
                        log.info(StrUtil.format((CharSequence)"\u672c\u6b21\u8bf7\u6c42\u7684\u5185\u5bb9\uff1a{}", (Object[])new Object[]{reqData}));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error(e.getMessage());
                        throw new EncryptionException(EncryptionExceptionEnum.RSA_DECRYPT_ERROR);
                    }
                    log.info(StrUtil.format((CharSequence)"\u8fd4\u56de\u6570\u636e\u52a0\u5bc6\u7684key\uff1a{}", (Object[])new Object[]{aesKey}));
                    EncryptionHolder.setAesKey(aesKey);
                    return new ByteArrayInputStream(reqData.getBytes(CharsetUtil.CHARSET_UTF_8));
                }
            };
        }
        return inputMessage;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new SunJCE());
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

