/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.seata.order.service.impl;

import cn.stylefeng.roses.kernel.seata.order.consumer.StorageConsumer;
import cn.stylefeng.roses.kernel.seata.order.consumer.WalletConsumer;
import cn.stylefeng.roses.kernel.seata.order.entity.Order;
import cn.stylefeng.roses.kernel.seata.order.mapper.OrderMapper;
import cn.stylefeng.roses.kernel.seata.order.service.OrderService;
import io.seata.spring.annotation.GlobalTransactional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
implements OrderService {
    @Resource
    private StorageConsumer storageConsumer;
    @Resource
    private WalletConsumer walletConsumer;
    @Resource
    private OrderMapper orderMapper;

    @Override
    @GlobalTransactional(rollbackFor={Exception.class})
    public Order create(String userId, String commodityCode, int orderCount) {
        Order order = new Order();
        this.orderMapper.insertOrder(order);
        this.storageConsumer.deduct(commodityCode, orderCount);
        this.walletConsumer.debit(userId, order.getTotalAmount());
        return order;
    }
}

