/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.scanner.starter;

import cn.hutool.core.util.StrUtil;
import cn.stylefeng.roses.kernel.scanner.ApiResourceScanner;
import cn.stylefeng.roses.kernel.scanner.DefaultResourceCollector;
import cn.stylefeng.roses.kernel.scanner.api.ResourceCollectorApi;
import cn.stylefeng.roses.kernel.scanner.api.pojo.scanner.ScannerProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GunsResourceAutoConfiguration {
    public static final String SCANNER_PREFIX = "scanner";
    @Value(value="${spring.application.name:}")
    private String springApplicationName;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;

    @Bean
    @ConfigurationProperties(prefix="scanner")
    public ScannerProperties scannerProperties() {
        return new ScannerProperties();
    }

    @Bean
    @ConditionalOnMissingBean(value={ApiResourceScanner.class})
    @ConditionalOnProperty(prefix="scanner", name={"open"}, havingValue="true")
    public ApiResourceScanner apiResourceScanner(ResourceCollectorApi resourceCollectorApi, ScannerProperties scannerProperties) {
        if (StrUtil.isBlank((CharSequence)scannerProperties.getAppCode())) {
            scannerProperties.setAppCode(this.springApplicationName);
        }
        if (StrUtil.isBlank((CharSequence)scannerProperties.getContextPath())) {
            scannerProperties.setContextPath(this.contextPath);
        }
        return new ApiResourceScanner(resourceCollectorApi, scannerProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceCollectorApi.class})
    @ConditionalOnProperty(prefix="scanner", name={"open"}, havingValue="true")
    public ResourceCollectorApi resourceCollectorApi() {
        return new DefaultResourceCollector();
    }
}

