/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.pay.alipay.config;

import com.alipay.easysdk.factory.Factory;
import com.alipay.easysdk.kernel.Config;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class AlipayConfig
implements ApplicationRunner {
    @Value(value="${alipay.appId}")
    private String appId;
    @Value(value="${alipay.merchantPrivateKey}")
    private String merchantPrivateKey;
    @Value(value="${alipay.alipayPublicKey}")
    private String alipayPublicKey;
    @Value(value="${alipay.gatewayHost}")
    private String gatewayHost;
    @Value(value="${alipay.notifyUrl:#{null}}")
    private String notifyUrl;
    @Value(value="${alipay.encryptKey:#{null}}")
    private String encryptKey;
    @Value(value="${alipay.merchantCertPath:#{null}}")
    private String merchantCertPath;
    @Value(value="${alipay.alipayCertPath:#{null}}")
    private String alipayCertPath;
    @Value(value="${alipay.alipayRootCertPath:#{null}}")
    private String alipayRootCertPath;

    public void run(ApplicationArguments args) throws Exception {
        Factory.setOptions((Config)this.getOptions());
    }

    private Config getOptions() {
        Config config = new Config();
        config.protocol = "https";
        config.gatewayHost = this.gatewayHost;
        config.signType = "RSA2";
        config.appId = this.appId;
        config.merchantPrivateKey = this.merchantPrivateKey;
        config.merchantCertPath = this.merchantCertPath;
        config.alipayCertPath = this.alipayCertPath;
        config.alipayRootCertPath = this.alipayRootCertPath;
        config.alipayPublicKey = this.alipayPublicKey;
        config.notifyUrl = this.notifyUrl;
        config.encryptKey = this.encryptKey;
        return config;
    }
}

