/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.pay.alipay.service.impl;

import cn.stylefeng.roses.kernel.pay.alipay.service.AlipayService;
import cn.stylefeng.roses.kernel.pay.api.PayApi;
import cn.stylefeng.roses.kernel.pay.api.pojo.TradeRefundResponse;
import com.alipay.easysdk.factory.Factory;
import com.alipay.easysdk.payment.common.models.AlipayTradeRefundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AlipayServiceImpl
implements AlipayService,
PayApi {
    private static final Logger log = LoggerFactory.getLogger(AlipayServiceImpl.class);

    @Override
    public String page(String orderName, String outTradeNo, String total, String returnUrl) {
        try {
            return Factory.Payment.Page().pay((String)orderName, (String)outTradeNo, (String)total, (String)returnUrl).body;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return e.getMessage();
        }
    }

    @Override
    public String wap(String orderName, String outTradeNo, String total, String quitUrl, String returnUrl) {
        try {
            return Factory.Payment.Wap().pay((String)orderName, (String)outTradeNo, (String)total, (String)quitUrl, (String)returnUrl).body;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return e.getMessage();
        }
    }

    @Override
    public TradeRefundResponse refund(String outTradeNo, String refundAmount) {
        try {
            AlipayTradeRefundResponse response = Factory.Payment.Common().refund(outTradeNo, refundAmount);
            if ("10000".equals(response.getCode())) {
                return TradeRefundResponse.builder().code("10000").msg(response.getMsg()).outTradeNo(response.getOutTradeNo()).refundFee(response.getRefundFee()).tradeNo(response.getTradeNo()).gmtRefundPay(response.getGmtRefundPay()).buyerLogonId(response.buyerLogonId).buyerUserId(response.buyerUserId).data((Object)response).build();
            }
            return TradeRefundResponse.error((String)response.msg, (Object)response);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return TradeRefundResponse.error((String)e.getMessage());
        }
    }
}

