/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.monitor.prometheus.service.impl;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.stylefeng.roses.kernel.monitor.api.exception.enums.MonitorExceptionEnum;
import cn.stylefeng.roses.kernel.monitor.api.pojo.prometheus.PromResponseInfo;
import cn.stylefeng.roses.kernel.monitor.api.pojo.prometheus.PromResultInfo;
import cn.stylefeng.roses.kernel.monitor.prometheus.mapper.PrometheusMenuMapper;
import cn.stylefeng.roses.kernel.monitor.prometheus.service.PrometheusService;
import cn.stylefeng.roses.kernel.rule.enums.StatusEnum;
import com.alibaba.fastjson.JSON;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrometheusServiceImpl
implements PrometheusService {
    private static final Logger log = LoggerFactory.getLogger(PrometheusServiceImpl.class);
    @Resource
    private PrometheusMenuMapper mapper;

    public List<PromResultInfo> getMetricInfo(String promURL, String promQL, String isRate, String rateMetric) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String httpRes = "";
        if (!StrUtil.isEmpty((CharSequence)isRate)) {
            paramMap.put("query", this.getRatePromQl(isRate, rateMetric, promQL));
        } else {
            paramMap.put("query", promQL);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(12, calendar.get(12) - 5);
        paramMap.put("start", calendar.getTime().getTime() / 1000L);
        paramMap.put("end", new Date().getTime() / 1000L);
        paramMap.put("step", 15);
        try {
            httpRes = HttpUtil.get((String)promURL, paramMap);
        }
        catch (IORuntimeException e) {
            log.error(MonitorExceptionEnum.PROMETHEUS_CONFIG_ERROR.getUserTip(), (Object)"", (Object)"");
            return null;
        }
        PromResponseInfo responseInfo = (PromResponseInfo)JSON.parseObject((String)httpRes, PromResponseInfo.class);
        if (ObjectUtil.isEmpty((Object)responseInfo)) {
            return null;
        }
        if (StrUtil.isEmpty((CharSequence)responseInfo.getStatus()) || !"success".equals(responseInfo.getStatus())) {
            log.error("prometheus\u914d\u7f6e\u5f02\u5e38\uff0c\u5177\u4f53\u4fe1\u606f\u4e3a\uff1a{}", (Object)responseInfo.getStatus());
            return null;
        }
        return responseInfo.getData().getResult();
    }

    private String getRatePromQl(String isRate, String rateMetric, String promQl) {
        StringBuilder ratePromQlBuilder = new StringBuilder(isRate);
        ratePromQlBuilder.append("(").append(rateMetric).append(promQl).append(")");
        return ratePromQlBuilder.toString();
    }

    @Transactional(rollbackFor={Exception.class})
    public void closePrometheusMenu() {
        this.mapper.displayOrClosePrometheusMenu(StatusEnum.DISABLE.getCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void displayPrometheusMenu() {
        this.mapper.displayOrClosePrometheusMenu(StatusEnum.ENABLE.getCode());
    }
}

