/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.monitor.system;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.NumberUtil;
import cn.stylefeng.roses.kernel.monitor.api.pojo.CpuInfo;
import cn.stylefeng.roses.kernel.monitor.api.pojo.JvmInfo;
import cn.stylefeng.roses.kernel.monitor.api.pojo.MemInfo;
import cn.stylefeng.roses.kernel.monitor.api.pojo.SysFileInfo;
import cn.stylefeng.roses.kernel.monitor.api.pojo.SysInfo;
import cn.stylefeng.roses.kernel.rule.util.IpInfoUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.Util;

public class SystemHardwareCalculator {
    private static final int OSHI_WAIT_SECOND = 1000;
    private CpuInfo cpu = new CpuInfo();
    private MemInfo mem = new MemInfo();
    private JvmInfo jvm = new JvmInfo();
    private SysInfo sys = new SysInfo();
    private List<SysFileInfo> sysFiles = new LinkedList<SysFileInfo>();

    public void calc() {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        this.setCpuInfo(hal.getProcessor());
        this.setMemInfo(hal.getMemory());
        this.setSysInfo();
        this.setJvmInfo();
        this.setSysFiles(si.getOperatingSystem());
    }

    private void setCpuInfo(CentralProcessor processor) {
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)1000L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long cSys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long totalCpu = user + nice + cSys + idle + iowait + irq + softirq + steal;
        this.cpu.setCpuNum(processor.getLogicalProcessorCount());
        this.cpu.setTotal((double)totalCpu);
        this.cpu.setSys((double)cSys);
        this.cpu.setUsed((double)user);
        this.cpu.setWait((double)iowait);
        this.cpu.setFree((double)idle);
    }

    private void setMemInfo(GlobalMemory memory) {
        this.mem.setTotal((double)memory.getTotal());
        this.mem.setUsed((double)(memory.getTotal() - memory.getAvailable()));
        this.mem.setFree((double)memory.getAvailable());
    }

    private void setSysInfo() {
        Properties props = System.getProperties();
        this.sys.setComputerName(IpInfoUtils.getHostName());
        this.sys.setComputerIp(NetUtil.getLocalhostStr());
        this.sys.setOsName(props.getProperty("os.name"));
        this.sys.setOsArch(props.getProperty("os.arch"));
        this.sys.setUserDir(props.getProperty("user.dir"));
    }

    private void setJvmInfo() {
        Properties props = System.getProperties();
        this.jvm.setTotal((double)Runtime.getRuntime().totalMemory());
        this.jvm.setMax((double)Runtime.getRuntime().maxMemory());
        this.jvm.setFree((double)Runtime.getRuntime().freeMemory());
        this.jvm.setVersion(props.getProperty("java.version"));
        this.jvm.setHome(props.getProperty("java.home"));
    }

    private void setSysFiles(OperatingSystem os) {
        FileSystem fileSystem = os.getFileSystem();
        List fsList = fileSystem.getFileStores();
        for (OSFileStore fs : fsList) {
            long free = fs.getUsableSpace();
            long total = fs.getTotalSpace();
            long used = total - free;
            SysFileInfo sysFile = new SysFileInfo();
            sysFile.setDirName(fs.getMount());
            sysFile.setSysTypeName(fs.getType());
            sysFile.setTypeName(fs.getName());
            sysFile.setTotal(this.convertFileSize(total));
            sysFile.setFree(this.convertFileSize(free));
            sysFile.setUsed(this.convertFileSize(used));
            if (total == 0L) {
                sysFile.setUsage(0.0);
            } else {
                sysFile.setUsage(NumberUtil.mul((double)NumberUtil.div((float)used, (float)total, (int)4), (float)100.0f));
            }
            this.sysFiles.add(sysFile);
        }
    }

    public String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size >= gb) {
            return String.format("%.1f GB", Float.valueOf((float)size / (float)gb));
        }
        if (size >= mb) {
            float f = (float)size / (float)mb;
            return String.format(f > 100.0f ? "%.0f MB" : "%.1f MB", Float.valueOf(f));
        }
        if (size >= kb) {
            float f = (float)size / (float)kb;
            return String.format(f > 100.0f ? "%.0f KB" : "%.1f KB", Float.valueOf(f));
        }
        return String.format("%d B", size);
    }

    public CpuInfo getCpu() {
        return this.cpu;
    }

    public MemInfo getMem() {
        return this.mem;
    }

    public JvmInfo getJvm() {
        return this.jvm;
    }

    public SysInfo getSys() {
        return this.sys;
    }

    public List<SysFileInfo> getSysFiles() {
        return this.sysFiles;
    }

    public void setCpu(CpuInfo cpu) {
        this.cpu = cpu;
    }

    public void setMem(MemInfo mem) {
        this.mem = mem;
    }

    public void setJvm(JvmInfo jvm) {
        this.jvm = jvm;
    }

    public void setSys(SysInfo sys) {
        this.sys = sys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemHardwareCalculator)) {
            return false;
        }
        SystemHardwareCalculator other = (SystemHardwareCalculator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CpuInfo this$cpu = this.getCpu();
        CpuInfo other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) {
            return false;
        }
        MemInfo this$mem = this.getMem();
        MemInfo other$mem = other.getMem();
        if (this$mem == null ? other$mem != null : !this$mem.equals(other$mem)) {
            return false;
        }
        JvmInfo this$jvm = this.getJvm();
        JvmInfo other$jvm = other.getJvm();
        if (this$jvm == null ? other$jvm != null : !this$jvm.equals(other$jvm)) {
            return false;
        }
        SysInfo this$sys = this.getSys();
        SysInfo other$sys = other.getSys();
        if (this$sys == null ? other$sys != null : !this$sys.equals(other$sys)) {
            return false;
        }
        List<SysFileInfo> this$sysFiles = this.getSysFiles();
        List<SysFileInfo> other$sysFiles = other.getSysFiles();
        return !(this$sysFiles == null ? other$sysFiles != null : !((Object)this$sysFiles).equals(other$sysFiles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemHardwareCalculator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CpuInfo $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : $cpu.hashCode());
        MemInfo $mem = this.getMem();
        result = result * 59 + ($mem == null ? 43 : $mem.hashCode());
        JvmInfo $jvm = this.getJvm();
        result = result * 59 + ($jvm == null ? 43 : $jvm.hashCode());
        SysInfo $sys = this.getSys();
        result = result * 59 + ($sys == null ? 43 : $sys.hashCode());
        List<SysFileInfo> $sysFiles = this.getSysFiles();
        result = result * 59 + ($sysFiles == null ? 43 : ((Object)$sysFiles).hashCode());
        return result;
    }

    public String toString() {
        return "SystemHardwareCalculator(cpu=" + this.getCpu() + ", mem=" + this.getMem() + ", jvm=" + this.getJvm() + ", sys=" + this.getSys() + ", sysFiles=" + this.getSysFiles() + ")";
    }
}

