/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.message.db.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.message.api.exception.MessageException;
import cn.stylefeng.roses.kernel.message.api.exception.enums.MessageExceptionEnum;
import cn.stylefeng.roses.kernel.message.api.pojo.request.MessageRequest;
import cn.stylefeng.roses.kernel.message.db.entity.SysMessage;
import cn.stylefeng.roses.kernel.message.db.mapper.SysMessageMapper;
import cn.stylefeng.roses.kernel.message.db.service.SysMessageService;
import cn.stylefeng.roses.kernel.rule.enums.YesOrNotEnum;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysMessageServiceImpl
extends ServiceImpl<SysMessageMapper, SysMessage>
implements SysMessageService {
    @Override
    public void add(MessageRequest messageRequest) {
        SysMessage sysMessage = new SysMessage();
        BeanUtil.copyProperties((Object)messageRequest, (Object)((Object)sysMessage), (String[])new String[0]);
        this.save((Object)sysMessage);
    }

    @Override
    public void del(MessageRequest messageRequest) {
        SysMessage sysMessage = this.querySysMessageById(messageRequest);
        sysMessage.setDelFlag(YesOrNotEnum.Y.getCode());
        this.updateById((Object)sysMessage);
    }

    @Override
    public void edit(MessageRequest messageRequest) {
        SysMessage sysMessage = new SysMessage();
        BeanUtil.copyProperties((Object)messageRequest, (Object)((Object)sysMessage), (String[])new String[0]);
        this.updateById((Object)sysMessage);
    }

    @Override
    public SysMessage detail(MessageRequest messageRequest) {
        LambdaQueryWrapper<SysMessage> queryWrapper = this.createWrapper(messageRequest);
        return (SysMessage)((Object)this.getOne((Wrapper)queryWrapper, false));
    }

    @Override
    public PageResult<SysMessage> findPage(MessageRequest messageRequest) {
        LambdaQueryWrapper<SysMessage> wrapper = this.createWrapper(messageRequest);
        Page page = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)page);
    }

    @Override
    public List<SysMessage> findList(MessageRequest messageRequest) {
        LambdaQueryWrapper<SysMessage> wrapper = this.createWrapper(messageRequest);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public Integer findCount(MessageRequest messageRequest) {
        LambdaQueryWrapper<SysMessage> wrapper = this.createWrapper(messageRequest);
        return this.count((Wrapper)wrapper);
    }

    private SysMessage querySysMessageById(MessageRequest messageRequest) {
        SysMessage sysMessage = (SysMessage)((Object)this.getById(messageRequest.getMessageId()));
        if (ObjectUtil.isEmpty((Object)((Object)sysMessage))) {
            throw new MessageException((AbstractExceptionEnum)MessageExceptionEnum.NOT_EXISTED, new Object[]{messageRequest.getMessageId()});
        }
        return sysMessage;
    }

    private LambdaQueryWrapper<SysMessage> createWrapper(MessageRequest messageRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(SysMessage::getDelFlag, (Object)YesOrNotEnum.Y.getCode());
        queryWrapper.orderByDesc(SysMessage::getMessageSendTime);
        if (ObjectUtil.isEmpty((Object)messageRequest)) {
            return queryWrapper;
        }
        String messageTitle = messageRequest.getMessageTitle();
        Long receiveUserId = messageRequest.getReceiveUserId();
        String messageType = messageRequest.getMessageType();
        Integer readFlag = messageRequest.getReadFlag();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)messageTitle), SysMessage::getMessageTitle, (Object)messageTitle);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)receiveUserId), SysMessage::getReceiveUserId, (Object)receiveUserId);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)messageType), SysMessage::getMessageType, (Object)messageType);
        queryWrapper.eq(ObjectUtil.isNotEmpty((Object)readFlag), SysMessage::getReadFlag, (Object)readFlag);
        return queryWrapper;
    }
}

