/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.starter;

import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import cn.stylefeng.roses.kernel.log.api.LogManagerApi;
import cn.stylefeng.roses.kernel.log.api.LogRecordApi;
import cn.stylefeng.roses.kernel.log.api.enums.LogSaveTypeEnum;
import cn.stylefeng.roses.kernel.log.api.expander.LogConfigExpander;
import cn.stylefeng.roses.kernel.log.api.pojo.log.SysLogProperties;
import cn.stylefeng.roses.kernel.log.api.threadpool.LogManagerThreadPool;
import cn.stylefeng.roses.kernel.log.db.DbLogManagerServiceImpl;
import cn.stylefeng.roses.kernel.log.db.DbLogRecordServiceImpl;
import cn.stylefeng.roses.kernel.log.db.service.SysLogService;
import cn.stylefeng.roses.kernel.log.db.service.impl.SysLogServiceImpl;
import cn.stylefeng.roses.kernel.log.file.FileLogManagerServiceImpl;
import cn.stylefeng.roses.kernel.log.file.FileLogRecordServiceImpl;
import cn.stylefeng.roses.kernel.log.requestapi.RequestApiLogRecordAop;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GunsLogAutoConfiguration {
    public static final String SYS_LOG_PREFIX = "sys-log";

    @Bean
    @ConditionalOnMissingBean(value={SysLogService.class})
    @ConditionalOnProperty(prefix="sys-log", name={"type"}, havingValue="db")
    public SysLogService sysLogService() {
        return new SysLogServiceImpl();
    }

    @Bean
    @ConfigurationProperties(prefix="sys-log")
    public SysLogProperties sysLogProperties() {
        return new SysLogProperties();
    }

    @Bean
    public RequestApiLogRecordAop requestApiLogRecordAop(SysLogProperties sysLogProperties, SysLogServiceImpl sysLogService) {
        if (StrUtil.isNotBlank((CharSequence)sysLogProperties.getType()) && LogSaveTypeEnum.FILE.getCode().equals(sysLogProperties.getType())) {
            String fileSavePath = "";
            fileSavePath = SystemUtil.getOsInfo().isWindows() ? LogConfigExpander.getLogFileSavePathWindows() : LogConfigExpander.getLogFileSavePathLinux();
            return new RequestApiLogRecordAop((LogRecordApi)new FileLogRecordServiceImpl(fileSavePath, new LogManagerThreadPool()));
        }
        return new RequestApiLogRecordAop((LogRecordApi)new DbLogRecordServiceImpl(new LogManagerThreadPool(), (SysLogService)sysLogService));
    }

    @Bean
    public LogManagerApi logManagerApi(SysLogProperties sysLogProperties) {
        if (StrUtil.isNotBlank((CharSequence)sysLogProperties.getType()) && LogSaveTypeEnum.FILE.getCode().equals(sysLogProperties.getType())) {
            String fileSavePath = "";
            fileSavePath = SystemUtil.getOsInfo().isWindows() ? LogConfigExpander.getLogFileSavePathWindows() : LogConfigExpander.getLogFileSavePathLinux();
            return new FileLogManagerServiceImpl(fileSavePath);
        }
        return new DbLogManagerServiceImpl();
    }

    @Bean
    public LogRecordApi logRecordApi(SysLogServiceImpl sysLogService) {
        return new DbLogRecordServiceImpl(new LogManagerThreadPool(), (SysLogService)sysLogService);
    }
}

