/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.file;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import cn.stylefeng.roses.kernel.log.api.LogRecordApi;
import cn.stylefeng.roses.kernel.log.api.pojo.record.LogRecordDTO;
import cn.stylefeng.roses.kernel.log.api.threadpool.LogManagerThreadPool;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class FileLogRecordServiceImpl
implements LogRecordApi {
    private final LogManagerThreadPool logManagerThreadPool;
    private final LogRefreshManager logRefreshManager;
    private final String fileSavePath;

    public FileLogRecordServiceImpl(String fileSavePath, LogManagerThreadPool logManagerThreadPool) {
        this.fileSavePath = fileSavePath;
        this.logManagerThreadPool = logManagerThreadPool;
        this.logRefreshManager = new LogRefreshManager();
        this.logRefreshManager.start();
    }

    public FileLogRecordServiceImpl(String fileSavePath, LogManagerThreadPool logManagerThreadPool, long sleepTime, int maxCount) {
        this.fileSavePath = fileSavePath;
        this.logManagerThreadPool = logManagerThreadPool;
        this.logRefreshManager = new LogRefreshManager(sleepTime, maxCount);
        this.logRefreshManager.start();
    }

    public void add(LogRecordDTO logRecordDTO) {
        if (logRecordDTO == null) {
            return;
        }
        this.addBatch(CollectionUtil.list((boolean)false, (Object[])new LogRecordDTO[]{logRecordDTO}));
    }

    public void addBatch(List<LogRecordDTO> list) {
        Date dateTime;
        if (ObjectUtil.isEmpty(list)) {
            return;
        }
        String appName = list.get(0).getAppName();
        if (StrUtil.isBlank((CharSequence)appName)) {
            appName = "app-logs";
        }
        if ((dateTime = list.get(0).getDateTime()) == null) {
            dateTime = new Date();
        }
        String dateStr = DateUtil.formatDate((Date)dateTime);
        String fileName = appName + "-" + dateStr + ".log";
        String fileAbsolutePath = this.fileSavePath + File.separator + fileName;
        boolean existFlag = FileUtil.exist((String)fileAbsolutePath);
        if (!existFlag) {
            FileUtil.touch((String)fileAbsolutePath);
        }
        ArrayList<String> outList = new ArrayList<String>();
        for (LogRecordDTO recordDTO : list) {
            outList.add(JSON.toJSONString((Object)recordDTO));
        }
        FileUtil.appendLines(outList, (String)fileAbsolutePath, (Charset)StandardCharsets.UTF_8);
    }

    public void addAsync(final LogRecordDTO logRecordDTO) {
        this.logManagerThreadPool.executeLog(new TimerTask(){

            @Override
            public void run() {
                FileLogRecordServiceImpl.this.logRefreshManager.putLog(logRecordDTO);
            }
        });
    }

    class LogRefreshManager
    extends Thread {
        private final Log log = LogFactory.get();
        private final long sleepTime;
        private final int maxCount;
        private final AtomicLong refreshMark = new AtomicLong();
        private final Queue<LogRecordDTO> queue = new ConcurrentLinkedQueue<LogRecordDTO>();
        public AtomicInteger count = new AtomicInteger(0);

        public LogRefreshManager() {
            this.sleepTime = 3000L;
            this.maxCount = 300;
        }

        public LogRefreshManager(long sleepTime) {
            this.sleepTime = sleepTime;
            this.maxCount = 300;
        }

        public LogRefreshManager(int maxCount) {
            this.sleepTime = 3000L;
            this.maxCount = maxCount;
        }

        public LogRefreshManager(long sleepTime, int maxCount) {
            this.sleepTime = sleepTime;
            this.maxCount = maxCount;
        }

        public void putLog(LogRecordDTO logRecordDTO) {
            int queueDataCount = this.count.get();
            if (queueDataCount == 0) {
                this.refreshMark.getAndSet(System.currentTimeMillis());
            }
            if (queueDataCount >= this.maxCount * 2) {
                return;
            }
            this.queue.offer(logRecordDTO);
            this.count.incrementAndGet();
        }

        private void refresh() {
            this.refreshMark.getAndSet(System.currentTimeMillis());
            int num = this.count.getAndSet(0);
            ArrayList<LogRecordDTO> cacheAll = new ArrayList<LogRecordDTO>(num);
            try {
                LogRecordDTO item;
                for (int i = 0; i < num && null != (item = this.queue.poll()); ++i) {
                    cacheAll.add(item);
                }
                FileLogRecordServiceImpl.this.addBatch(cacheAll);
            }
            catch (Exception e) {
                for (LogRecordDTO recordDTO : cacheAll) {
                    this.queue.offer(recordDTO);
                }
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                this.log.error(e.getMessage(), new Object[0]);
            }
        }

        private void timing() {
            try {
                if (this.refreshMark.get() + this.sleepTime <= System.currentTimeMillis() && this.count.get() > 0) {
                    this.refresh();
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                this.log.error(e.getMessage(), new Object[0]);
            }
        }

        private void listener() {
            try {
                if (this.count.get() >= this.maxCount) {
                    this.refresh();
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                this.log.error(e.getMessage(), new Object[0]);
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.listener();
                    this.timing();
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                this.log.error(e.getMessage(), new Object[0]);
                return;
            }
        }
    }
}

