/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.file;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.auth.api.context.LoginContext;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.log.api.LogManagerApi;
import cn.stylefeng.roses.kernel.log.api.constants.LogConstants;
import cn.stylefeng.roses.kernel.log.api.exception.LogException;
import cn.stylefeng.roses.kernel.log.api.exception.enums.LogExceptionEnum;
import cn.stylefeng.roses.kernel.log.api.pojo.manage.LogManagerRequest;
import cn.stylefeng.roses.kernel.log.api.pojo.record.LogRecordDTO;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLogManagerServiceImpl
implements LogManagerApi {
    private static final Logger log = LoggerFactory.getLogger(FileLogManagerServiceImpl.class);
    private final String fileSavePath;
    private Integer total;

    public FileLogManagerServiceImpl(String fileSavePath) {
        this.fileSavePath = fileSavePath;
    }

    public List<LogRecordDTO> findList(LogManagerRequest logManagerParam) {
        PageResult<LogRecordDTO> pageResult = this.findPage(logManagerParam);
        return pageResult.getRows();
    }

    public PageResult<LogRecordDTO> findPage(LogManagerRequest logManagerParam) {
        Object pointer;
        if (ObjectUtil.isEmpty((Object)logManagerParam.getAppName())) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.APP_NAME_NOT_EXIST);
        }
        if (ObjectUtil.isEmpty((Object)logManagerParam.getBeginDate())) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.BEGIN_DATETIME_NOT_EXIST);
        }
        String filePath = this.getLogPath(logManagerParam.getAppName(), logManagerParam.getBeginDate());
        long filePointer = 0L;
        if (logManagerParam.getPageNo() == null) {
            logManagerParam.setPageNo(LogConstants.DEFAULT_BEGIN_PAGE_NO);
        } else if (!LogConstants.DEFAULT_BEGIN_PAGE_NO.equals(logManagerParam.getPageNo()) && ObjectUtil.isNotEmpty((Object)(pointer = LoginContext.me().getLoginUser().getOtherInfos().get((Object)"filePointer")))) {
            filePointer = (Long)pointer;
        }
        if (logManagerParam.getPageSize() == null) {
            logManagerParam.setPageSize(LogConstants.DEFAULT_PAGE_SIZE);
        }
        PageResult pageResult = new PageResult();
        pageResult.setPageSize(logManagerParam.getPageSize());
        List<LogRecordDTO> dtos = this.readLog(filePath, filePointer, logManagerParam.getPageSize());
        pageResult.setRows(dtos);
        pageResult.setTotalRows(this.total);
        return pageResult;
    }

    public void del(LogManagerRequest logManagerParam) {
        if (ObjectUtil.isEmpty((Object)logManagerParam.getAppName())) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.APP_NAME_NOT_EXIST);
        }
        if (ObjectUtil.isEmpty((Object)logManagerParam.getBeginDate())) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.BEGIN_DATETIME_NOT_EXIST);
        }
        if (ObjectUtil.isEmpty((Object)logManagerParam.getEndDate())) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.END_DATETIME_NOT_EXIST);
        }
        List<String> dates = FileLogManagerServiceImpl.getIntervalDate(logManagerParam.getBeginDate(), logManagerParam.getEndDate());
        for (String date : dates) {
            String logPath = this.getLogPath(logManagerParam.getAppName(), date);
            if (!FileUtil.exist((String)logPath)) continue;
            FileUtil.del((String)logPath);
        }
    }

    public LogRecordDTO detail(LogManagerRequest logManagerRequest) {
        if (ObjectUtil.isEmpty((Object)logManagerRequest.getAppName())) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.APP_NAME_NOT_EXIST);
        }
        if (ObjectUtil.isEmpty((Object)logManagerRequest.getBeginDate())) {
            throw new LogException((AbstractExceptionEnum)LogExceptionEnum.BEGIN_DATETIME_NOT_EXIST);
        }
        String filePath = this.getLogPath(logManagerRequest.getAppName(), logManagerRequest.getBeginDate());
        return this.readLog(filePath, logManagerRequest.getLogId());
    }

    private String getLogPath(String appName, String date) {
        String fileName = appName + "-" + DateUtil.parse((CharSequence)date).toDateStr() + ".log";
        String fileAbsolutePath = this.fileSavePath + File.separator;
        return fileAbsolutePath + fileName;
    }

    private LogRecordDTO readLog(String path, Long logId) {
        if (!FileUtil.exist((String)path)) {
            return null;
        }
        LogRecordDTO logRecordDTO = new LogRecordDTO();
        try {
            String str;
            RandomAccessFile file = new RandomAccessFile(path, "r");
            while (!ObjectUtil.isNotEmpty((Object)(str = file.readLine())) || !(logRecordDTO = this.parseObject(str)).getLogId().equals(logId)) {
            }
            return logRecordDTO;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            log.error(e.getMessage());
            return logRecordDTO;
        }
    }

    private List<LogRecordDTO> readLog(String path, long filePointer, int lineNum) {
        if (!FileUtil.exist((String)path)) {
            return null;
        }
        ArrayList<LogRecordDTO> readLines = new ArrayList<LogRecordDTO>();
        try {
            RandomAccessFile file = new RandomAccessFile(path, "r");
            file.seek(filePointer);
            for (int i = 0; i < lineNum; ++i) {
                LogRecordDTO recordDTO;
                String str = file.readLine();
                if (!ObjectUtil.isNotEmpty((Object)str) || !ObjectUtil.isNotEmpty((Object)(recordDTO = this.parseObject(str)))) continue;
                readLines.add(recordDTO);
            }
            this.total = this.getTotalLines(new File(path));
            LoginContext.me().getLoginUser().setOtherInfos(Dict.create().set("filePointer", (Object)file.getFilePointer()));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            log.error(e.getMessage());
        }
        return readLines;
    }

    private LogRecordDTO parseObject(String jsonStr) {
        LogRecordDTO logRecordDTO = null;
        try {
            logRecordDTO = (LogRecordDTO)JSON.parseObject((String)new String(FileLogManagerServiceImpl.getBytes(jsonStr.toCharArray())), LogRecordDTO.class);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            log.error(e.getMessage());
        }
        return logRecordDTO;
    }

    public static byte[] getBytes(char[] chars) {
        byte[] result = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = (byte)chars[i];
        }
        return result;
    }

    public static List<String> getIntervalDate(String start, String end) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<String> list = new ArrayList<String>();
        try {
            Date dateStart = sdf.parse(start);
            Date dateEnd = sdf.parse(end);
            Date date = dateStart;
            Calendar cd = Calendar.getInstance();
            while (date.getTime() <= dateEnd.getTime()) {
                list.add(sdf.format(date));
                cd.setTime(date);
                cd.add(5, 1);
                date = cd.getTime();
            }
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                e.printStackTrace();
            }
            log.error(e.getMessage());
        }
        return list;
    }

    public int getTotalLines(File file) throws IOException {
        FileReader in = new FileReader(file);
        LineNumberReader reader = new LineNumberReader(in);
        reader.skip(Long.MAX_VALUE);
        int lines = reader.getLineNumber();
        reader.close();
        return lines;
    }
}

