/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.log.business.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.stylefeng.roses.kernel.db.api.factory.PageFactory;
import cn.stylefeng.roses.kernel.db.api.factory.PageResultFactory;
import cn.stylefeng.roses.kernel.db.api.pojo.page.PageResult;
import cn.stylefeng.roses.kernel.dsctn.api.context.DataSourceContext;
import cn.stylefeng.roses.kernel.log.api.pojo.business.SysLogBusinessContentRequest;
import cn.stylefeng.roses.kernel.log.api.pojo.entity.SysLogBusinessContent;
import cn.stylefeng.roses.kernel.log.business.mapper.SysLogBusinessContentMapper;
import cn.stylefeng.roses.kernel.log.business.service.SysLogBusinessContentService;
import cn.stylefeng.roses.kernel.rule.enums.DbTypeEnum;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysLogBusinessContentServiceImpl
extends ServiceImpl<SysLogBusinessContentMapper, SysLogBusinessContent>
implements SysLogBusinessContentService {
    @Override
    public PageResult<SysLogBusinessContent> findPage(SysLogBusinessContentRequest sysLogBusinessContentRequest) {
        LambdaQueryWrapper<SysLogBusinessContent> wrapper = this.createWrapper(sysLogBusinessContentRequest);
        wrapper.select(new SFunction[]{SysLogBusinessContent::getLogContent});
        Page sysRolePage = (Page)this.page((IPage)PageFactory.defaultPage(), (Wrapper)wrapper);
        return PageResultFactory.createPageResult((Page)sysRolePage);
    }

    @Override
    public void batchSaveContent(List<SysLogBusinessContent> sysLogBusinessContentList) {
        if (DbTypeEnum.MYSQL.equals((Object)DataSourceContext.me().getCurrentDbType())) {
            ((SysLogBusinessContentMapper)this.getBaseMapper()).insertBatchSomeColumn(sysLogBusinessContentList);
        } else {
            this.saveBatch(sysLogBusinessContentList);
        }
    }

    private LambdaQueryWrapper<SysLogBusinessContent> createWrapper(SysLogBusinessContentRequest sysLogBusinessContentRequest) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Long businessLogId = sysLogBusinessContentRequest.getBusinessLogId();
        queryWrapper.eq(ObjectUtil.isNotNull((Object)businessLogId), SysLogBusinessContent::getBusinessLogId, (Object)businessLogId);
        String searchText = sysLogBusinessContentRequest.getSearchText();
        queryWrapper.like(ObjectUtil.isNotEmpty((Object)searchText), SysLogBusinessContent::getLogContent, (Object)searchText);
        queryWrapper.orderByAsc(SysLogBusinessContent::getContentId);
        return queryWrapper;
    }
}

