/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.guns.sms.modular.executor;

import cn.hutool.core.util.RandomUtil;
import cn.stylefeng.guns.sms.core.enums.MessageType;
import cn.stylefeng.guns.sms.core.enums.SmsSendStatus;
import cn.stylefeng.guns.sms.core.enums.SmsVerifyResult;
import cn.stylefeng.guns.sms.core.sms.SmsManager;
import cn.stylefeng.guns.sms.modular.executor.SmsExecutor;
import cn.stylefeng.guns.sms.modular.model.SendMessageParam;
import cn.stylefeng.guns.sms.modular.model.VerifySMSParam;
import cn.stylefeng.guns.sms.modular.service.SmsInfoService;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SmsExecutorImpl
implements SmsExecutor {
    private static final Logger log = LoggerFactory.getLogger(SmsExecutorImpl.class);
    @Autowired
    private SmsManager smsManager;
    @Autowired
    private SmsInfoService smsInfoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean sendShortMessage(SendMessageParam sendMessageParam) {
        Map<String, Object> params = sendMessageParam.getParams();
        log.info("\u53d1\u9001\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)sendMessageParam));
        if (MessageType.MESSAGE.equals((Object)sendMessageParam.getMessageType())) {
            this.smsManager.sendSms(sendMessageParam.getPhoneNumbers(), sendMessageParam.getTemplateCode(), params);
            log.info("\u53d1\u9001\u77ed\u4fe1Provider\u63a5\u53e3--message\uff0cparams\u7684map\u5177\u4f53\u4e3a\uff1a" + JSON.toJSONString(params));
        } else {
            String validateCode = null;
            if (params != null && params.get("code") != null) {
                validateCode = params.get("code").toString();
            } else {
                validateCode = RandomUtil.randomNumbers((int)6);
                if (params == null) {
                    params = new HashMap<String, Object>();
                }
                params.put("code", validateCode);
            }
            log.info("\u53d1\u9001\u77ed\u4fe1Provider\u63a5\u53e3\uff0cparams\u7684map\u5177\u4f53\u4e3a\uff1a" + JSON.toJSONString(params));
            log.info("\u53d1\u9001\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u9a8c\u8bc1\u7801\u4e3a\uff1a" + validateCode);
            Integer keyId = this.smsInfoService.saveSmsInfo(sendMessageParam, validateCode);
            log.info("\u5f00\u59cb\u53d1\u9001\u77ed\u4fe1\uff1a\u53d1\u9001\u7684\u7535\u8bdd\u53f7\u7801= " + sendMessageParam.getPhoneNumbers() + ",\u53d1\u9001\u7684\u6a21\u677f\u53f7=" + sendMessageParam.getTemplateCode() + "\uff0c\u53d1\u9001\u7684\u53c2\u6570\u662f\uff1a" + JSON.toJSONString(params));
            this.smsManager.sendSms(sendMessageParam.getPhoneNumbers(), sendMessageParam.getTemplateCode(), params);
            this.smsInfoService.updateSmsInfo(keyId, SmsSendStatus.SUCCESS);
        }
        return true;
    }

    @Override
    public SmsVerifyResult verifyShortMessage(VerifySMSParam verifySMSParam) {
        log.info("\u9a8c\u8bc1\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)verifySMSParam));
        SmsVerifyResult smsVerifyResult = this.smsInfoService.validateSmsInfo(verifySMSParam);
        log.info("\u9a8c\u8bc1\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u54cd\u5e94\u7ed3\u679c\u4e3a\uff1a" + JSON.toJSONString((Object)((Object)smsVerifyResult)));
        return smsVerifyResult;
    }

    @Override
    public SmsSendStatus getMessageSendStatus(Integer smsId) {
        return null;
    }
}

