/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.guns.sms.core.sms.service;

import cn.hutool.core.date.DateUtil;
import cn.stylefeng.guns.sms.config.properties.AliyunSmsProperties;
import cn.stylefeng.guns.sms.core.cache.MultiSignManager;
import cn.stylefeng.guns.sms.core.enums.SmsResultEnum;
import cn.stylefeng.guns.sms.core.exception.SmsException;
import cn.stylefeng.guns.sms.core.sms.SmsManager;
import cn.stylefeng.guns.sms.modular.model.SmsSendRecord;
import cn.stylefeng.roses.kernel.model.util.ValidateUtil;
import com.alibaba.fastjson.JSON;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.QuerySendDetailsResponse;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AliyunSmsManager
implements SmsManager {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsManager.class);
    @Autowired
    private MultiSignManager multiSignManager;
    @Autowired
    private AliyunSmsProperties aliyunSmsProperties;

    @Override
    public void sendSms(String phoneNumber, String templateCode, Map<String, Object> params) {
        log.info("\u5f00\u59cb\u53d1\u9001\u963f\u91cc\u4e91\u77ed\u4fe1\uff0c\u624b\u673a\u53f7\u662f\uff1a" + phoneNumber + ",\u6a21\u677f\u53f7\u662f\uff1a" + templateCode + ",\u53c2\u6570\u662f\uff1a" + JSON.toJSONString(params));
        this.assertSendSmsParams(phoneNumber, templateCode, params, this.aliyunSmsProperties);
        IClientProfile profile = this.initClientProfile();
        DefaultAcsClient acsClient = new DefaultAcsClient(profile);
        SendSmsResponse sendSmsResponse = this.createSmsRequest(phoneNumber, templateCode, params, (IAcsClient)acsClient);
        if (sendSmsResponse.getCode() != null && SmsResultEnum.OK.getCode().equals(sendSmsResponse.getCode())) {
            return;
        }
        String code = SmsResultEnum.SYSTEM_ERROR.getCode();
        String errorMessage = SmsResultEnum.SYSTEM_ERROR.getMessage();
        for (SmsResultEnum smsResultEnum : SmsResultEnum.values()) {
            if (!smsResultEnum.getCode().equals(sendSmsResponse.getCode())) continue;
            code = smsResultEnum.getCode();
            errorMessage = smsResultEnum.getMessage();
        }
        log.error("\u53d1\u9001\u77ed\u4fe1\u5f02\u5e38\uff01code = " + code + ",message = " + errorMessage);
        throw new SmsException(code, errorMessage);
    }

    @Override
    public List<SmsSendRecord> getAlreadySendList(String phoneNumber, Date sendDate, Integer pageNo) {
        this.assertGetSendListParams(phoneNumber, sendDate, pageNo);
        IClientProfile clientProfile = this.initClientProfile();
        DefaultAcsClient acsClient = new DefaultAcsClient(clientProfile);
        QuerySendDetailsRequest request = new QuerySendDetailsRequest();
        request.setPhoneNumber(phoneNumber);
        String dateString = DateUtil.format((Date)sendDate, (String)"yyyyMMdd");
        request.setSendDate(dateString);
        request.setPageSize(Long.valueOf(50L));
        request.setCurrentPage(Long.valueOf(pageNo == null ? 1L : (long)pageNo.intValue()));
        QuerySendDetailsResponse querySendDetailsResponse = null;
        try {
            querySendDetailsResponse = (QuerySendDetailsResponse)acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (ClientException e) {
            log.error("\u83b7\u53d6\u5df2\u53d1\u77ed\u4fe1\u5217\u8868\u5f02\u5e38\uff01", (Throwable)e);
        }
        if (querySendDetailsResponse.getCode() != null && querySendDetailsResponse.getCode().equals("OK")) {
            List smsSendDetailDTOs = querySendDetailsResponse.getSmsSendDetailDTOs();
            ArrayList<SmsSendRecord> results = new ArrayList<SmsSendRecord>();
            for (QuerySendDetailsResponse.SmsSendDetailDTO smsSendDetailDTO : smsSendDetailDTOs) {
                SmsSendRecord smsSendRecord = new SmsSendRecord();
                BeanUtils.copyProperties((Object)smsSendDetailDTO, (Object)smsSendRecord);
                results.add(smsSendRecord);
            }
            return results;
        }
        log.error("\u83b7\u53d6\u77ed\u4fe1\u5217\u8868\u5f02\u5e38\uff01code = " + querySendDetailsResponse.getCode());
        throw new SmsException(querySendDetailsResponse.getCode(), "\u83b7\u53d6\u77ed\u4fe1\u5217\u8868\u5f02\u5e38\uff01");
    }

    private IClientProfile initClientProfile() {
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        String product = "Dysmsapi";
        String domain = "dysmsapi.aliyuncs.com";
        String accessKeyId = this.aliyunSmsProperties.getAccessKeyId();
        String accessKeySecret = this.aliyunSmsProperties.getAccessKeySecret();
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)accessKeyId, (String)accessKeySecret);
        try {
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)"Dysmsapi", (String)"dysmsapi.aliyuncs.com");
        }
        catch (ClientException e) {
            log.error("\u521d\u59cb\u5316\u963f\u91cc\u4e91sms\u5f02\u5e38\uff01", (Throwable)e);
        }
        return profile;
    }

    private SendSmsResponse createSmsRequest(String phoneNumber, String templateCode, Map<String, Object> params, IAcsClient acsClient) {
        SendSmsRequest request = new SendSmsRequest();
        request.setMethod(MethodType.POST);
        request.setPhoneNumbers(phoneNumber);
        request.setSignName(this.getSmsSign(phoneNumber));
        request.setTemplateCode(templateCode);
        request.setTemplateParam(JSON.toJSONString(params));
        request.setOutId("yourOutId");
        SendSmsResponse sendSmsResponse = null;
        try {
            sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        }
        catch (ClientException e) {
            log.error("\u521d\u59cb\u5316\u963f\u91cc\u4e91sms\u5f02\u5e38\uff01\u53ef\u80fd\u662faccessKey\u548csecret\u9519\u8bef\uff01", (Throwable)e);
            throw new SmsException(SmsResultEnum.INIT_SMS_CLIENT_ERROR.getCode(), SmsResultEnum.INIT_SMS_CLIENT_ERROR.getMessage());
        }
        return sendSmsResponse;
    }

    private void assertSendSmsParams(String phoneNumber, String templateCode, Map<String, Object> params, AliyunSmsProperties aliyunSmsProperties) {
        if (ValidateUtil.isOneEmpty((Object[])new Object[]{phoneNumber, templateCode, params, aliyunSmsProperties})) {
            log.error("\u963f\u91cc\u4e91\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38\uff01\u8bf7\u6c42\u53c2\u6570\u5b58\u5728\u7a7a\uff01");
            throw new SmsException(SmsResultEnum.PARAM_NULL.getCode(), SmsResultEnum.PARAM_NULL.getMessage());
        }
    }

    private void assertGetSendListParams(String phoneNumber, Date sendDate, Integer pageNo) {
        if (ValidateUtil.isOneEmpty((Object[])new Object[]{phoneNumber, sendDate})) {
            log.error("\u963f\u91cc\u4e91\u83b7\u53d6\u77ed\u4fe1\u53d1\u9001\u5217\u8868\u5f02\u5e38\uff01\u8bf7\u6c42\u53c2\u6570\u5b58\u5728\u7a7a\uff01");
            throw new SmsException(SmsResultEnum.PARAM_NULL.getCode(), SmsResultEnum.PARAM_NULL.getMessage());
        }
    }

    private String getSmsSign(String phone) {
        String signName = this.aliyunSmsProperties.getSignName();
        if (!signName.contains(",")) {
            log.info("\u53d1\u9001\u77ed\u4fe1\uff0c\u7b7e\u540d\u4e3a\uff1a" + signName + ",\u7535\u8bdd\u4e3a\uff1a" + phone);
            return signName;
        }
        return this.multiSignManager.getSign(phone, signName);
    }
}

