/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.guns.sms.modular.service;

import cn.stylefeng.guns.sms.config.properties.AliyunSmsProperties;
import cn.stylefeng.guns.sms.core.enums.SmsResultEnum;
import cn.stylefeng.guns.sms.core.enums.SmsSendStatus;
import cn.stylefeng.guns.sms.core.enums.SmsVerifyResult;
import cn.stylefeng.guns.sms.core.exception.SmsException;
import cn.stylefeng.guns.sms.modular.entity.SmsInfo;
import cn.stylefeng.guns.sms.modular.mapper.SmsInfoMapper;
import cn.stylefeng.guns.sms.modular.model.SendMessageParam;
import cn.stylefeng.guns.sms.modular.model.VerifySMSParam;
import cn.stylefeng.roses.kernel.model.util.ValidateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class SmsInfoService
extends ServiceImpl<SmsInfoMapper, SmsInfo> {
    private static final Logger log = LoggerFactory.getLogger(SmsInfoService.class);
    @Autowired
    private AliyunSmsProperties aliyunSmsProperties;

    public Integer saveSmsInfo(SendMessageParam sendMessageParam, String validateCode) {
        if (ValidateUtil.isOneEmpty((Object[])new Object[]{sendMessageParam.getPhoneNumbers(), validateCode, sendMessageParam.getTemplateCode()})) {
            log.error("\u5b58\u50a8\u77ed\u4fe1\u5230\u6570\u636e\u5e93\u5931\u8d25\uff01\u6709\u53c2\u6570\u4e3a\u7a7a\uff01");
            throw new SmsException(SmsResultEnum.PARAM_NULL.getCode(), SmsResultEnum.PARAM_NULL.getMessage());
        }
        Date nowDate = new Date();
        long invalidateTime = nowDate.getTime() + (long)(this.aliyunSmsProperties.getInvalidateMinutes() * 60 * 1000);
        Date invalidate = new Date(invalidateTime);
        SmsInfo smsInfo = new SmsInfo();
        smsInfo.setCreateTime(nowDate);
        smsInfo.setInvalidTime(invalidate);
        smsInfo.setPhoneNumbers(sendMessageParam.getPhoneNumbers());
        smsInfo.setStatus(SmsSendStatus.WAITING.getCode());
        smsInfo.setSource(sendMessageParam.getSmsSendSource().getCode());
        smsInfo.setTemplateCode(sendMessageParam.getTemplateCode());
        smsInfo.setValidateCode(validateCode);
        this.save(smsInfo);
        log.info("\u53d1\u9001\u77ed\u4fe1\uff0c\u5b58\u50a8\u77ed\u4fe1\u5230\u6570\u636e\u5e93\uff0c\u6570\u636e\u4e3a\uff1a" + JSON.toJSONString((Object)smsInfo));
        return smsInfo.getId();
    }

    public void updateSmsInfo(Integer keyId, SmsSendStatus smsSendStatus) {
        SmsInfo smsInfo = (SmsInfo)this.getById(keyId);
        smsInfo.setStatus(smsSendStatus.getCode());
        this.updateById(smsInfo);
    }

    @Transactional(rollbackFor={Exception.class})
    public SmsVerifyResult validateSmsInfo(VerifySMSParam verifySMSParam) {
        if (ValidateUtil.isOneEmpty((Object[])new Object[]{verifySMSParam.getPhoneNumbers(), verifySMSParam.getCode(), verifySMSParam.getTemplateCode()})) {
            log.error("\u6821\u9a8c\u77ed\u4fe1\u662f\u5426\u6b63\u786e\u5931\u8d25\uff01\u6709\u53c2\u6570\u4e3a\u7a7a\uff01");
            throw new SmsException(SmsResultEnum.PARAM_NULL.getCode(), SmsResultEnum.PARAM_NULL.getMessage());
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"phone_numbers", (Object)verifySMSParam.getPhoneNumbers())).and(f -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)f.eq((Object)"source", (Object)verifySMSParam.getSmsSendSource().getCode());
        })).and(f -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)f.eq((Object)"template_code", (Object)verifySMSParam.getTemplateCode());
        });
        wrapper.orderByDesc((Object)"create_time");
        List smsInfos = this.list((Wrapper)wrapper);
        log.info("\u9a8c\u8bc1\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u67e5\u8be2\u5230sms\u8bb0\u5f55\uff1a" + JSON.toJSONString((Object)smsInfos));
        if (smsInfos == null || smsInfos.isEmpty()) {
            log.info("\u9a8c\u8bc1\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u627e\u4e0d\u5230\u9a8c\u8bc1\u7801\u8bb0\u5f55\uff0c\u54cd\u5e94\u9a8c\u8bc1\u5931\u8d25\uff01");
            return SmsVerifyResult.ERROR;
        }
        SmsInfo smsInfo = (SmsInfo)smsInfos.get(0);
        if (SmsSendStatus.INVALID.getCode().equals(smsInfo.getStatus())) {
            log.info("\u9a8c\u8bc1\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u77ed\u4fe1\u72b6\u6001\u662f\u5931\u6548\uff0c\u54cd\u5e94\u9a8c\u8bc1\u5931\u8d25\uff01");
            return SmsVerifyResult.ERROR;
        }
        if (!verifySMSParam.getCode().equals(smsInfo.getValidateCode())) {
            log.info("\u9a8c\u8bc1\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u9a8c\u8bc1\u624b\u673a\u53f7\u548c\u9a8c\u8bc1\u7801\u4e0d\u4e00\u81f4\uff0c\u54cd\u5e94\u9a8c\u8bc1\u5931\u8d25\uff01");
            return SmsVerifyResult.ERROR;
        }
        Date invalidTime = smsInfo.getInvalidTime();
        if (invalidTime == null || new Date().after(invalidTime)) {
            log.info("\u9a8c\u8bc1\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u9a8c\u8bc1\u7801\u8d85\u65f6\uff0c\u54cd\u5e94\u9a8c\u8bc1\u5931\u8d25\uff01");
            return SmsVerifyResult.EXPIRED;
        }
        smsInfo.setStatus(SmsSendStatus.INVALID.getCode());
        this.updateById(smsInfo);
        log.info("\u9a8c\u8bc1\u77ed\u4fe1Provider\u63a5\u53e3\uff0c\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u6210\u529f\uff01");
        return SmsVerifyResult.SUCCESS;
    }
}

