/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.guns.sms.core.cache.impl;

import cn.stylefeng.guns.sms.core.cache.MultiSignManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapSignManager
implements MultiSignManager {
    private static final Logger log = LoggerFactory.getLogger(MapSignManager.class);
    private static final Long EXPIRED_TIME = 86400L;
    private Map<String, String> cacheMap = new ConcurrentHashMap<String, String>();

    @Override
    public String getSign(String phone, String signName) {
        this.clearMap();
        String[] signNames = signName.split(",");
        String lastSignName = this.cacheMap.get(phone);
        if (lastSignName == null) {
            this.cacheMap.put(phone, signNames[0]);
            log.info("\u53d1\u9001\u77ed\u4fe1\uff0c\u7b7e\u540d\u4e3a\uff1a" + signNames[0] + ",\u7535\u8bdd\u4e3a\uff1a" + phone);
            return signNames[0];
        }
        for (String name : signNames) {
            if (name.equals(lastSignName)) continue;
            this.cacheMap.put(phone, name);
            log.info("\u53d1\u9001\u77ed\u4fe1\uff0c\u7b7e\u540d\u4e3a\uff1a" + name + ",\u7535\u8bdd\u4e3a\uff1a" + phone);
            return name;
        }
        this.cacheMap.put(phone, signNames[0]);
        log.info("\u53d1\u9001\u77ed\u4fe1\uff0c\u7b7e\u540d\u4e3a\uff1a" + signNames[0] + ",\u7535\u8bdd\u4e3a\uff1a" + phone);
        return signNames[0];
    }

    private void clearMap() {
        if (this.cacheMap.size() >= 1000) {
            this.cacheMap.clear();
        }
    }
}

